/*
 * Decompiled with CFR 0.152.
 */
package com.hyperic.hq.plugin.insight.measurement;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxMeasurementPlugin;
import org.hyperic.hq.product.jmx.MxUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsightMeasurementPlugin
extends MxMeasurementPlugin {
    private final Log log = LogFactory.getLog(InsightMeasurementPlugin.class);
    private static final String ATTR_METRIC = "metric";
    private static final String ATTR_SMALL_SAMPLES = "smallSamples";
    private static final String METRIC_SUFFIX = ":type=counter";
    private static final String OBJ_HEALTH = "Health";
    private static final String DIVIDE_SIGN = "/";
    private static final double HEALTH_EXCELLENT = 1.0;
    private static final double HEALTH_GOOD = 0.85;

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        if (metric.isAvail()) {
            return super.getValue(metric);
        }
        String objectName = Metric.decode((String)metric.getObjectName());
        String attributeName = metric.getAttributeName();
        Properties metricProperties = metric.getProperties();
        Pattern pattern = Pattern.compile("(.*)\\[(.*)\\]\\.(.*)");
        Matcher matcher = pattern.matcher(attributeName);
        boolean matched = matcher.find();
        if (!matched) {
            return super.getValue(metric);
        }
        String jmxAttrName = matcher.group(1);
        String arrayIndexRegex = matcher.group(2);
        String compositeKey = matcher.group(3);
        String msg = null;
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)metricProperties);
            Object value = mServer.getAttribute(new ObjectName(objectName), jmxAttrName);
            if (!(value instanceof CompositeData[])) {
                throw new PluginException("Expected attribute type CompositeData[] but received attribute " + value);
            }
            CompositeData[] attributeValues = (CompositeData[])value;
            Map<String, String> compositeMap = this.getCompositeArrayMatchValues(arrayIndexRegex);
            CompositeData[] datas = this.getMatchingCompositeData(attributeValues, compositeMap);
            return this.calcMetricValue(datas, jmxAttrName, compositeKey);
        }
        catch (MalformedURLException e) {
            msg = "Malformed URL: [" + metricProperties.getProperty("jmx.url") + "]";
            throw new PluginException(msg, (Throwable)e);
        }
        catch (IOException e) {
            msg = "Can't connect to MBeanServer [" + metricProperties + "]: " + e;
            throw new MetricUnreachableException(msg, (Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            msg = "Attribute not found [" + objectName + ":" + jmxAttrName + "]: " + e;
            throw new MetricNotFoundException(msg, (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            msg = "ObjectName not found [" + objectName + "]: " + e;
            throw new MetricNotFoundException(msg, (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            msg = "Malformed ObjectName [" + objectName + "]";
            throw new MetricInvalidException(msg, (Throwable)e);
        }
        catch (MBeanException e) {
            msg = "Invocation error [" + metric.toString() + "]: " + e;
            throw new PluginException(msg, (Throwable)e);
        }
        catch (ReflectionException e) {
            msg = "Invocation error [" + metric.toString() + "]: " + e;
            throw new PluginException(msg, (Throwable)e);
        }
        catch (MetricNotFoundException e) {
            throw new MetricNotFoundException("CompositeData array element matching expression " + arrayIndexRegex + " was not found for Attribute[" + objectName + ":" + jmxAttrName + "]", (Throwable)e);
        }
    }

    private CompositeData getDataMatchingAttrValues(CompositeData[] attributeValues, Map<String, String> keyValsToMatch) {
        CompositeData data = null;
        for (CompositeData attrValue : attributeValues) {
            boolean matches = true;
            for (Map.Entry<String, String> attrsToMatch : keyValsToMatch.entrySet()) {
                Object value = attrValue.get(attrsToMatch.getKey());
                if (attrsToMatch.getValue().equals(value)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            data = attrValue;
            break;
        }
        return data;
    }

    private CompositeData[] getMatchingCompositeData(CompositeData[] attributeValues, Map<String, String> keyValsToMatch) {
        CompositeData[] datas = null;
        if (keyValsToMatch.containsKey(ATTR_METRIC)) {
            String[] values = keyValsToMatch.get(ATTR_METRIC).split(DIVIDE_SIGN);
            datas = new CompositeData[values.length];
            for (int i = 0; i < values.length; ++i) {
                HashMap<String, String> temp = new HashMap<String, String>(keyValsToMatch);
                temp.put(ATTR_METRIC, values[i]);
                datas[i] = this.getDataMatchingAttrValues(attributeValues, temp);
            }
        } else {
            CompositeData data = this.getDataMatchingAttrValues(attributeValues, keyValsToMatch);
            datas = new CompositeData[]{data};
        }
        return datas;
    }

    private Map<String, String> getCompositeArrayMatchValues(String arrayIndexRegex) {
        String[] regexes = arrayIndexRegex.split(",");
        Pattern arrayIndexRegexPattern = Pattern.compile("(.*)=(.*)");
        HashMap<String, String> keyValsToMatch = new HashMap<String, String>(regexes.length);
        for (String regex : regexes) {
            Matcher arrayIndexMatcher = arrayIndexRegexPattern.matcher(regex);
            if (!arrayIndexMatcher.find()) continue;
            String key = arrayIndexMatcher.group(1);
            String value = arrayIndexMatcher.group(2);
            if (key.equals(ATTR_METRIC)) {
                String[] metricValues = value.split(DIVIDE_SIGN);
                value = metricValues[0] + METRIC_SUFFIX;
                if (metricValues.length == 2) {
                    value = value + DIVIDE_SIGN + metricValues[1] + METRIC_SUFFIX;
                }
            }
            keyValsToMatch.put(key, value);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("key=" + key + " value=" + value));
        }
        return keyValsToMatch;
    }

    private MetricValue calcMetricValue(CompositeData[] datas, String jmxAttrName, String compositeKey) throws MetricNotFoundException {
        if (datas.length > 2) {
            throw new MetricNotFoundException("Calculations for more than 2 metrics are currently not supported.");
        }
        Double calcVal = null;
        for (int i = 0; i < datas.length; ++i) {
            if (datas[i] == null) {
                throw new MetricNotFoundException("CompositeData is null");
            }
            double doubleVal = this.getMetricDoubleValue(datas[i], jmxAttrName, compositeKey);
            if (calcVal == null) {
                calcVal = new Double(doubleVal);
                continue;
            }
            if (doubleVal == 0.0) {
                calcVal = new Double(0.0);
                continue;
            }
            double newVal = calcVal / doubleVal;
            calcVal = new Double(newVal);
        }
        return new MetricValue(calcVal);
    }

    private double getMetricDoubleValue(CompositeData data, String objectName, String compositeKey) {
        double doubleVal = 0.0;
        if (OBJ_HEALTH.equals(objectName)) {
            doubleVal = this.getHealthMetricDoubleValue(data, compositeKey);
        } else {
            Number numberVal = (Number)data.get(compositeKey);
            if (numberVal != null) {
                doubleVal = numberVal.doubleValue();
            }
        }
        return doubleVal;
    }

    private double getHealthMetricDoubleValue(CompositeData data, String compositeKey) {
        double doubleVal = 1.0;
        Number numberVal = (Number)data.get(compositeKey);
        if (numberVal != null) {
            doubleVal = numberVal.doubleValue();
            Boolean isSmallSamples = (Boolean)data.get(ATTR_SMALL_SAMPLES);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("smallSample=" + isSmallSamples + ", health=" + doubleVal));
            }
            if (isSmallSamples != null && isSmallSamples.booleanValue() && doubleVal < 0.85) {
                doubleVal = 0.85;
            }
        }
        return doubleVal;
    }
}

