/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.appha;

import com.vmware.vim25.HostHardwareSummary;
import com.vmware.vim25.HostListSummary;
import com.vmware.vim25.ManagedObjectNotFound;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.plugin.appha.ManagedEntityNotFoundException;
import org.hyperic.hq.plugin.appha.ObjectCache;
import org.hyperic.hq.plugin.appha.VSphereConnection;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.security.DefaultSSLProviderImpl;
import org.hyperic.util.security.KeystoreConfig;
import org.hyperic.util.timer.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSphereUtil
extends ServiceInstance {
    private static final long CACHE_TIMEOUT = 600000L;
    static final String HOST_SYSTEM = "HostSystem";
    static final String POOL = "ResourcePool";
    static final String VM = "VirtualMachine";
    static final String PROP_URL = "url";
    static final String PROP_HOSTNAME = "hostname";
    static final String PROP_USERNAME = "user";
    static final String PROP_PASSWORD = "pass";
    private static final Log _log = LogFactory.getLog((String)VSphereUtil.class.getName());
    private InventoryNavigator _nav;
    private String _url;
    private final Map<String, ObjectCache<Map<String, ManagedEntity>>> entityCache = new HashMap<String, ObjectCache<Map<String, ManagedEntity>>>();

    public VSphereUtil(URL url, String username, String password, boolean ignoreCert) throws RemoteException, MalformedURLException {
        super(url, username, password, ignoreCert);
        this._url = url.toString();
    }

    private static void configureSSLKeystore() {
        AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig();
        DefaultSSLProviderImpl sslProvider = new DefaultSSLProviderImpl((KeystoreConfig)keystoreConfig, keystoreConfig.isAcceptUnverifiedCert());
        SSLContext sslContext = sslProvider.getSSLContext();
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new AllowAllHostnameVerifier());
    }

    static VSphereUtil getInstance(Properties props) throws PluginException {
        String url = VSphereUtil.getURL(props);
        if (url == null) {
            throw new PluginException("url not configured");
        }
        String username = props.getProperty(PROP_USERNAME);
        String password = props.getProperty(PROP_PASSWORD);
        try {
            VSphereUtil.configureSSLKeystore();
            return new VSphereUtil(new URL(url), username, password, false);
        }
        catch (Exception e) {
            VSphereConnection.evict(url);
            throw new PluginException("ServiceInstance(" + url + ", " + username + "): " + e, (Throwable)e);
        }
    }

    public static VSphereUtil getInstance(ConfigResponse config) throws PluginException {
        return VSphereUtil.getInstance(config.toProperties());
    }

    public boolean isSessionValid() {
        try {
            Calendar clock = this.currentTime();
            if (clock == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(this._url + " session invalid, clock=NULL"));
                }
                return false;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(this._url + " session valid, clock=" + new Date(clock.getTimeInMillis())));
            }
            return true;
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(this._url + " session invalid: " + e.getMessage()), (Throwable)e);
            }
            return false;
        }
    }

    public boolean isESX() {
        return !"gsx".equals(this.getAboutInfo().getProductLineId());
    }

    public InventoryNavigator getNavigator() {
        if (this._nav == null) {
            this._nav = new InventoryNavigator((ManagedEntity)this.getRootFolder());
        }
        return this._nav;
    }

    Map<String, ManagedEntity> findByUuidFromInventory(String type, Set<String> uuids) throws PluginException {
        if (uuids == null || uuids.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        StopWatch watch = new StopWatch();
        HashMap<String, ManagedEntity> inventory = new HashMap<String, ManagedEntity>(uuids.size());
        try {
            ManagedEntity[] entities = this.find(type);
            for (int i = 0; entities != null && i < entities.length; ++i) {
                ManagedEntity entity = entities[i];
                String entUuid = VSphereUtil.getUuid(entity);
                if (entUuid == null || !uuids.contains(entUuid)) continue;
                inventory.put(entUuid, entity);
                if (inventory.size() != uuids.size()) continue;
                break;
            }
        }
        catch (Exception ex) {
            throw new PluginException(type + "/" + uuids + ": " + ex, (Throwable)ex);
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("findByUuidFromInventory: type=" + type + ", uuids=" + uuids + ", managedEntities=" + inventory + ", time=" + watch));
            }
        }
        return inventory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ManagedEntity findByUuid(String type, String uuid) throws PluginException {
        Exception ex;
        ManagedEntity obj;
        Map<String, ManagedEntity> cached;
        block10: {
            Map<String, ManagedEntity> map = cached = this.entityCache.get(type) == null || this.entityCache.get(type).isExpired() ? null : this.entityCache.get(type).getEntity();
            if (cached != null) {
                return (ManagedEntity)cached.get(uuid);
            }
            StopWatch watch = new StopWatch();
            obj = null;
            ex = null;
            cached = new HashMap<String, ManagedEntity>();
            try {
                ManagedEntity[] entities = this.find(type);
                for (int i = 0; entities != null && i < entities.length; ++i) {
                    ManagedEntity entity = entities[i];
                    String entUuid = VSphereUtil.getUuid(entity);
                    if (entUuid == null) continue;
                    if (uuid.equals(entUuid)) {
                        obj = entity;
                    }
                    cached.put(entUuid, entity);
                }
                if (!_log.isDebugEnabled()) break block10;
            }
            catch (Exception e) {
                ex = e;
                break block10;
            }
            _log.debug((Object)("findByUuid: type=" + type + ", uuid=" + uuid + ", managedEntity=" + obj + ", cacheSize=" + cached.size() + ", time=" + watch));
            break block10;
            finally {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("findByUuid: type=" + type + ", uuid=" + uuid + ", managedEntity=" + obj + ", cacheSize=" + cached.size() + ", time=" + watch));
                }
            }
        }
        cached.put(uuid, obj);
        this.entityCache.put(type, new ObjectCache<Map<String, ManagedEntity>>(cached, 600000L));
        if (ex != null) {
            throw new PluginException(type + "/" + uuid + ": " + ex, (Throwable)ex);
        }
        if (obj != null) return obj;
        throw new ManagedEntityNotFoundException(type + "/" + uuid + ": not found");
    }

    public ManagedEntity findByMOR(String type, String value) throws PluginException {
        ManagedEntity[] managedEntities = this.find(type);
        ManagedEntity obj = null;
        for (ManagedEntity managedEntity : managedEntities) {
            if (!managedEntity.getMOR().getVal().equals(value)) continue;
            obj = managedEntity;
            break;
        }
        if (obj == null) {
            throw new ManagedEntityNotFoundException(type + "/" + value + ": not found");
        }
        return obj;
    }

    public ManagedEntity find(String type, String name) throws PluginException {
        ManagedEntity obj = null;
        try {
            obj = this.getNavigator().searchManagedEntity(type, name);
        }
        catch (Exception e) {
            throw new PluginException(type + "/" + name + ": " + e, (Throwable)e);
        }
        if (obj == null) {
            throw new ManagedEntityNotFoundException(type + "/" + name + ": not found");
        }
        return obj;
    }

    public ManagedEntity getByTypeAndName(String type, String name) throws PluginException {
        ManagedEntity rtn;
        try {
            rtn = this.getNavigator().searchManagedEntity(type, name);
        }
        catch (Exception e) {
            throw new PluginException(type + ": " + e, (Throwable)e);
        }
        if (rtn == null) {
            throw new ManagedEntityNotFoundException("name=" + name + ",type=" + type + ": not found");
        }
        return rtn;
    }

    public ManagedEntity[] find(String type) throws PluginException {
        ManagedEntity[] obj;
        try {
            obj = this.getNavigator().searchManagedEntities(type);
        }
        catch (Exception e) {
            throw new PluginException(type + ": " + e, (Throwable)e);
        }
        if (obj == null) {
            throw new ManagedEntityNotFoundException(type + ": not found");
        }
        return obj;
    }

    public HostSystem getHost(String host) throws PluginException {
        return (HostSystem)this.find(HOST_SYSTEM, host);
    }

    static String getUuid(ManagedEntity entity) {
        if (entity == null) {
            return null;
        }
        String uuid = null;
        try {
            if (entity instanceof HostSystem) {
                HostSystem host = (HostSystem)entity;
                HostListSummary summary = host.getSummary();
                if (summary == null) {
                    return null;
                }
                HostHardwareSummary hardware = summary.getHardware();
                if (hardware == null) {
                    return null;
                }
                uuid = hardware.getUuid();
            } else if (entity instanceof VirtualMachine) {
                VirtualMachine vm = (VirtualMachine)entity;
                VirtualMachineConfigInfo config = vm.getConfig();
                if (config == null) {
                    return null;
                }
                uuid = config.getUuid();
            }
        }
        catch (Exception e) {
            Throwable causeBy = e.getCause();
            if (e instanceof ManagedObjectNotFound || causeBy instanceof ManagedObjectNotFound) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("getUuid: ManagedEntity[name=" + entity.getName() + "] not found."));
                }
            } else {
                _log.info((Object)("Could not get UUID for ManagedEntity[name=" + entity.getName() + "]: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
        return uuid;
    }

    public static String getURL(Properties props) {
        return props.getProperty(PROP_URL);
    }

    public static void dispose(VSphereUtil vim) {
        if (vim != null) {
            vim.getServerConnection().logout();
        }
    }
}

