/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.multilogtrack;

import java.io.File;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class LogTrackMeasurementPlugin
extends MeasurementPlugin {
    private final Sigar sigar = new Sigar();

    public MetricValue getValue(Metric metric) throws MetricUnreachableException, PluginException {
        String logfile = metric.getObjectProperty("logfile");
        File file = new File(logfile);
        if (metric.isAvail()) {
            if (!file.exists()) {
                return new MetricValue(0.0);
            }
            return new MetricValue(1.0);
        }
        if (!file.exists()) {
            throw new MetricUnreachableException("file=" + logfile + " does not exist");
        }
        try {
            return new MetricValue(this.sigar.getFileInfo(logfile).getSize());
        }
        catch (SigarException e) {
            throw new PluginException((Throwable)e);
        }
    }
}

