/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.util.Arrays;
import java.util.List;
import org.hyperic.hq.plugin.weblogic.WeblogicDeployer;
import org.hyperic.hq.plugin.weblogic.WeblogicJMXControl;
import org.hyperic.hq.plugin.weblogic.WeblogicMetric;
import org.hyperic.hq.plugin.weblogic.WeblogicUtil;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PluginException;

public class WeblogicApplicationControl
extends WeblogicJMXControl {
    private WeblogicDeployer deployer;
    protected static final String[] ACTIONS = new String[]{"deploy", "start", "undeploy", "stop"};
    private static final List COMMANDS = Arrays.asList(ACTIONS);
    private static final String APP_METRIC = WeblogicMetric.template(WeblogicMetric.APPLICATION, "Deployed");

    public List getActions() {
        return COMMANDS;
    }

    protected String getComponentMetric() {
        return APP_METRIC;
    }

    protected String getPath() {
        try {
            return (String)WeblogicUtil.getRemoteMBeanValue(this.getConfiguredComponentMetric(), "Path");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getComponentTarget(Metric metric) throws IllegalArgumentException {
        String[] targets = this.deployer.getComponentTargets(metric);
        String server = this.getServer();
        for (int i = 0; i < targets.length; ++i) {
            if (!targets[i].equals(server)) continue;
            return server;
        }
        if (targets.length == 1) {
            return targets[0];
        }
        String msg = "Component has multiple targets: " + Arrays.asList(targets);
        throw new IllegalArgumentException(msg);
    }

    protected String getServer() {
        return this.getConfig().getValue("server");
    }

    protected String getTarget() {
        return null;
    }

    protected String getApplication() {
        return this.getConfig().getValue("application");
    }

    protected String getModule() {
        return null;
    }

    public void doAction(String action) throws PluginException {
        if (!COMMANDS.contains(action)) {
            super.doAction(action);
            return;
        }
        this.deployer = new WeblogicDeployer();
        try {
            this.deployer.configure(this.getAdminURL(), this.getAdminUsername(), this.getAdminPassword());
            this.deployer.setTarget(this.getTarget());
            this.deployer.setApplication(this.getApplication());
            this.deployer.setModule(this.getModule());
            this.deployer.doAction(action);
            this.setResult(0);
        }
        catch (PluginException e) {
            this.setResult(-1);
            this.setMessage(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.setResult(-1);
            this.setMessage(e.getMessage());
        }
        this.deployer = null;
    }
}

