/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.util.timer.StopWatch;
import weblogic.security.Security;
import weblogic.security.auth.callback.URLCallback;

public class WeblogicAuth
implements CallbackHandler {
    private static Map handlers = Collections.synchronizedMap(new HashMap());
    private static final String LOGIN_MODULE = "org.hyperic.hq.weblogic";
    private static Log log = LogFactory.getLog(WeblogicAuth.class);
    private LoginContext loginContext = null;
    private Subject subject = null;
    private String url;
    private String username;
    private char[] passwordArray;

    private WeblogicAuth() {
    }

    public static WeblogicAuth getInstance(Metric metric) {
        return WeblogicAuth.getInstance(metric.getProperties());
    }

    public static void clearCache() {
        handlers.clear();
    }

    public static WeblogicAuth getInstance(Properties props) {
        String url = props.getProperty("admin.url", "");
        String username = props.getProperty("admin.username", "");
        String password = props.getProperty("admin.password", "");
        return WeblogicAuth.getInstance(url, username, password);
    }

    public static WeblogicAuth getInstance(String url, String username, String password) {
        int hash = 0;
        hash ^= url.hashCode();
        hash ^= username.hashCode();
        Integer key = new Integer(hash ^= password.hashCode());
        WeblogicAuth auth = (WeblogicAuth)handlers.get(key);
        if (auth == null) {
            auth = new WeblogicAuth();
            handlers.put(key, auth);
            auth.url = url;
            auth.username = username;
            auth.passwordArray = password.toCharArray();
        }
        return auth;
    }

    public Object runAs(PrivilegedAction action) throws SecurityException {
        return Security.runAs((Subject)this.getSubject(), (PrivilegedAction)action);
    }

    public Subject getSubject() throws SecurityException {
        if (this.subject != null) {
            return this.subject;
        }
        StopWatch timer = null;
        if (this.loginContext == null) {
            if (log.isDebugEnabled()) {
                timer = new StopWatch();
            }
            try {
                this.loginContext = new LoginContext(LOGIN_MODULE, this);
                this.loginContext.login();
            }
            catch (LoginException e) {
                this.loginContext = null;
                throw new SecurityException(e.getMessage());
            }
        }
        this.subject = this.loginContext.getSubject();
        if (timer != null) {
            log.debug((Object)(this.url + " login took: " + timer));
        }
        if (this.subject == null) {
            throw new SecurityException("Authentication failed: reason unknown.");
        }
        return this.subject;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                switch (toc.getMessageType()) {
                    case 0: {
                        log.info((Object)toc.getMessage());
                        break;
                    }
                    case 2: {
                        log.error((Object)toc.getMessage());
                        break;
                    }
                    case 1: {
                        log.warn((Object)toc.getMessage());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported message type: " + toc.getMessageType());
                    }
                }
                continue;
            }
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof URLCallback) {
                URLCallback uc = (URLCallback)callbacks[i];
                uc.setURL(this.url);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(this.passwordArray);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

