/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import javax.management.InstanceNotFoundException;
import org.hyperic.hq.plugin.weblogic.WeblogicUtil;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;
import weblogic.management.ManagementException;
import weblogic.management.WebLogicObjectName;
import weblogic.management.deploy.DeployerRuntime;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.runtime.DeployerRuntimeMBean;

public class WeblogicDeployer {
    private DeployerRuntimeMBean deployer;
    private String target = null;
    private String source = null;
    private String application = null;
    private String module = null;
    private final String[] EX_MESSAGES = new String[]{"Failed to contact", "Invalid user name or password"};

    private String fixupMessage(Exception e) {
        String msg = e.getMessage();
        for (int i = 0; i < this.EX_MESSAGES.length; ++i) {
            if (!msg.startsWith(this.EX_MESSAGES[i])) continue;
            return this.EX_MESSAGES[i];
        }
        return msg;
    }

    public void configure(String url, String username, String password) throws IllegalArgumentException {
        try {
            this.deployer = DeployerRuntime.getDeployerRuntime((String)username, (String)password, (String)url);
        }
        catch (InstanceNotFoundException e) {
            String msg = "Deployer not found at " + url;
            throw new IllegalArgumentException(msg);
        }
        catch (IllegalArgumentException e) {
            String msg = "Error getting deployer: " + this.fixupMessage(e);
            throw new IllegalArgumentException(msg);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String value) {
        this.target = value;
    }

    public void setSource(String value) {
        this.source = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setApplication(String value) {
        this.application = value;
    }

    public String getApplication() {
        return this.application;
    }

    public void setModule(String value) {
        this.module = value;
    }

    public String getModule() {
        return this.module;
    }

    protected String[] getComponentTargets(Metric metric) throws IllegalArgumentException {
        WebLogicObjectName[] targets = new WebLogicObjectName[]{};
        String err = null;
        try {
            targets = (WebLogicObjectName[])WeblogicUtil.getRemoteMBeanValue(metric, "Targets");
        }
        catch (MetricNotFoundException e) {
            err = "MBean instance not found: " + metric.getObjectName();
        }
        catch (MetricUnreachableException e) {
            err = e.getMessage();
        }
        catch (PluginException e) {
            err = e.getMessage();
        }
        if (err != null) {
            throw new IllegalArgumentException(err);
        }
        String[] names = new String[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            names[i] = targets[i].getName();
        }
        return names;
    }

    public void doAction(String action) throws PluginException, IllegalArgumentException {
        block10: {
            String[] stringArray;
            String target = this.getTarget();
            String source = this.getSource();
            String module = this.getModule();
            if (module == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = module;
            }
            String[] modules = stringArray;
            DeploymentData info = null;
            String app = this.getApplication();
            String staging = null;
            String id = null;
            if (app == null) {
                throw new IllegalArgumentException("application not specified");
            }
            if (modules != null && target == null) {
                throw new IllegalArgumentException("target not specified");
            }
            if (target != null) {
                info = new DeploymentData();
                info.addTarget(target, modules);
            }
            try {
                if (action.equals("deploy") || action.equals("start")) {
                    this.deployer.activate(source, app, staging, info, id);
                    break block10;
                }
                if (action.equals("undeploy")) {
                    this.deployer.unprepare(app, info, id);
                    break block10;
                }
                if (action.equals("stop")) {
                    this.deployer.deactivate(app, info, id);
                    break block10;
                }
                String msg = "unsupported action: " + action;
                throw new IllegalArgumentException(msg);
            }
            catch (ManagementException e) {
                throw new PluginException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

