/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.weblogic.WeblogicDetector;
import org.hyperic.hq.plugin.weblogic.WeblogicProductPlugin;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.util.config.ConfigResponse;

public class WeblogicDetectorNodeManager
extends ServerDetector
implements AutoServerDetector {
    private static final String PTQL_QUERY = "State.Name.eq=java,Args.*.eq=weblogic.NodeManager";
    private static final Log log = LogFactory.getLog(WeblogicDetector.class);

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        long[] pids;
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        if (!WeblogicProductPlugin.NEW_DISCOVERY) {
            return servers;
        }
        for (long pid : pids = WeblogicDetectorNodeManager.getPids((String)PTQL_QUERY)) {
            try {
                String cwd = WeblogicDetectorNodeManager.getSigar().getProcExe(pid).getCwd();
                File confFile = new File(cwd, "nodemanager.properties");
                Properties props = new Properties();
                log.debug((Object)("[" + pid + "] loadin config: " + confFile));
                props.load(new FileInputStream(confFile));
                log.debug((Object)("[" + pid + "] version=" + props.getProperty("PropertiesVersion")));
                if (!props.getProperty("PropertiesVersion").equalsIgnoreCase(this.getTypeInfo().getVersion())) continue;
                String port = props.getProperty("ListenPort");
                String host = props.getProperty("ListenAddress", WeblogicDetectorNodeManager.getPlatformName());
                if (host.equals("")) {
                    host = WeblogicDetectorNodeManager.getPlatformName();
                }
                ServerResource server = this.createServerResource(cwd);
                String name = this.getTypeInfo().getName() + " " + host + ":" + port;
                if (WeblogicProductPlugin.usePlatformName && WeblogicProductPlugin.NEW_DISCOVERY) {
                    name = WeblogicDetectorNodeManager.getPlatformName() + " " + name;
                }
                server.setName(name);
                ConfigResponse cf = new ConfigResponse();
                cf.setValue("nodemgr.address", host);
                cf.setValue("nodemgr.port", port);
                this.populateListeningPorts(pid, cf, true);
                this.setProductConfig(server, cf);
                servers.add(server);
            }
            catch (Exception e) {
                log.debug((Object)("[" + pid + "] Error getting process info, reason: '" + e.getMessage() + "'"), (Throwable)e);
            }
        }
        return servers;
    }

    private void populateListeningPorts(long pid, ConfigResponse productConfig, boolean b) {
        try {
            Class<?> du = Class.forName("org.hyperic.hq.product.DetectionUtil");
            Method plp = du.getMethod("populateListeningPorts", Long.TYPE, ConfigResponse.class, Boolean.TYPE);
            plp.invoke(null, pid, productConfig, b);
        }
        catch (ClassNotFoundException ex) {
            log.debug((Object)"[populateListeningPorts] Class 'DetectionUtil' not found", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            log.debug((Object)"[populateListeningPorts] Method 'populateListeningPorts' not found", (Throwable)ex);
        }
        catch (Exception ex) {
            log.debug((Object)"[populateListeningPorts] Problem with Method 'populateListeningPorts'", (Throwable)ex);
        }
    }
}

