/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.security.PrivilegedAction;
import java.util.Map;
import org.hyperic.hq.plugin.weblogic.WeblogicAuth;
import org.hyperic.hq.plugin.weblogic.WeblogicMetric;
import org.hyperic.hq.plugin.weblogic.WeblogicProductPlugin;
import org.hyperic.hq.plugin.weblogic.WeblogicUtil;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServiceTypeInfo;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;

public class WeblogicMeasurementPlugin
extends MeasurementPlugin
implements PrivilegedAction {
    private static final boolean useJAAS = WeblogicProductPlugin.useJAAS();
    private Metric metric;
    private static final String SERVER_AVAIL_ATTR = "StateVal";
    private static final String SERVER_AVAIL_ATTR_61 = "State";
    private static final String APP_AVAIL_ATTR = "Deployed";
    private static final String EJB_AVAIL_ATTR = "Status";
    private static final String WEBAPP_AVAIL_ATTR = "Status";
    private static final String JDBC_CONN_AVAIL_ATTR = "PoolState";
    private static final String EXQ_AVAIL_ATTR = "Name";
    private static final String[][] PLATFORM_HELP_PROPS = new String[][]{{"weblogic.prefix", "/usr/local/bea", "C:\\\\bea"}};

    public WeblogicMeasurementPlugin() {
        this.setName("weblogic");
    }

    protected String[][] getPlatformHelpProperties() {
        return PLATFORM_HELP_PROPS;
    }

    protected Map getMeasurementProperties() {
        TypeInfo info = this.getTypeInfo();
        Map props = WeblogicMetric.getMetricProps(info.getVersion());
        return props;
    }

    private boolean isAvail(Metric metric) {
        String attr = metric.getAttributeName();
        boolean isAvail = attr.equals(SERVER_AVAIL_ATTR) || attr.equals(SERVER_AVAIL_ATTR_61) || attr.equals("Status") || attr.equals("Status") || attr.equals(APP_AVAIL_ATTR) || attr.equals(JDBC_CONN_AVAIL_ATTR) || attr.equals(EXQ_AVAIL_ATTR);
        return isAvail;
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        block7: {
            boolean isAvail = this.isAvail(metric);
            try {
                if (useJAAS) {
                    return this.getValueAs(metric);
                }
                return this.getWeblogicValue(metric);
            }
            catch (MetricUnreachableException e) {
                if (!isAvail) {
                    throw e;
                }
            }
            catch (MetricNotFoundException e) {
                if (!isAvail) {
                    throw e;
                }
            }
            catch (Exception e) {
                if (isAvail) break block7;
                throw new PluginException(e.getMessage(), (Throwable)e);
            }
        }
        return new MetricValue(0.0);
    }

    private MetricValue getWeblogicValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        Double val = null;
        boolean isAvail = this.isAvail(metric);
        Object obj = WeblogicUtil.getRemoteMBeanValue(metric);
        val = isAvail ? new Double(WeblogicUtil.convertStateVal(obj)) : new Double(obj.toString());
        return new MetricValue((Number)val, System.currentTimeMillis());
    }

    private MetricValue getValueAs(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        Object obj;
        WeblogicAuth auth = WeblogicAuth.getInstance(metric);
        this.metric = metric;
        try {
            obj = auth.runAs(this);
        }
        catch (SecurityException e) {
            throw new MetricUnreachableException(e.getMessage(), (Throwable)e);
        }
        if (obj instanceof MetricValue) {
            return (MetricValue)obj;
        }
        if (obj instanceof PluginException) {
            throw (PluginException)((Object)obj);
        }
        if (obj instanceof MetricNotFoundException) {
            throw (MetricNotFoundException)((Object)obj);
        }
        if (obj instanceof MetricUnreachableException) {
            throw (MetricUnreachableException)((Object)obj);
        }
        if (obj instanceof Exception) {
            Exception e = (Exception)obj;
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        throw new IllegalArgumentException();
    }

    public Object run() {
        try {
            return this.getWeblogicValue(this.metric);
        }
        catch (Exception e) {
            return e;
        }
    }

    private String getServiceName() {
        ServiceTypeInfo service = (ServiceTypeInfo)this.getTypeInfo();
        String name = service.getName();
        String sname = service.getServerName();
        return name.substring(sname.length() + 1);
    }

    public String translate(String template, ConfigResponse config) {
        TypeInfo info = this.getTypeInfo();
        template = WeblogicMetric.translateNode(template, config);
        template = super.translate(template, config);
        String beanTok = "${BeanType}";
        if (template.indexOf("${BeanType}") != -1) {
            String beanType = this.getServiceName();
            beanType = StringUtil.replace((String)beanType, (String)" ", (String)"");
            template = StringUtil.replace((String)template, (String)"${BeanType}", (String)beanType);
        } else if (info.getType() == 2 && info.getVersion().equals("6.1")) {
            template = StringUtil.replace((String)template, (String)SERVER_AVAIL_ATTR, (String)SERVER_AVAIL_ATTR_61);
        }
        return template;
    }
}

