/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic.jmx;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicQuery;

public class BaseServerQuery
extends WeblogicQuery {
    private static HashMap addressMap = new HashMap();
    protected static final String ATTR_LISTEN_ADDR = "ListenAddress";
    protected static final String ATTR_LISTEN_PORT = "ListenPort";
    protected static final String ATTR_SSL_LISTEN_PORT = "SSLListenPort";

    public String getResourceName() {
        return this.getResourceType();
    }

    public String getResourceFullName() {
        return this.getResourceType() + " " + this.getFullName();
    }

    public String getInstallPath() {
        return null;
    }

    protected String getControlProgram() {
        return null;
    }

    public String getIdentifier() {
        return this.getInstallPath();
    }

    public Properties getControlConfig() {
        Properties props = new Properties();
        props.setProperty("program", this.getControlProgram());
        props.setProperty("timeout", String.valueOf(600));
        return props;
    }

    public boolean isAdmin() {
        return false;
    }

    public String getListenAddress() {
        String addr = this.getAttribute(ATTR_LISTEN_ADDR);
        if (addr == null || addr.length() == 0) {
            return "localhost";
        }
        return addr;
    }

    public String getListenPort() {
        return this.getAttribute(ATTR_LISTEN_PORT);
    }

    public String getSSLListenPort() {
        return this.getAttribute(ATTR_SSL_LISTEN_PORT);
    }

    public String getFqdn() {
        String address = this.getListenAddress();
        String fqdn = (String)addressMap.get(address);
        if (fqdn == null) {
            try {
                fqdn = InetAddress.getByName(address).getHostName();
            }
            catch (UnknownHostException e) {
                fqdn = address;
            }
            addressMap.put(address, fqdn);
        }
        return fqdn;
    }
}

