/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.functions;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionOwner;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.functions.Function3Args;
import com.sun.org.apache.xpath.internal.functions.WrongNumberArgsException;
import java.util.Vector;

public class FunctionMultiArgs
extends Function3Args {
    static final long serialVersionUID = 7117257746138417181L;
    Expression[] m_args;

    public Expression[] getArgs() {
        return this.m_args;
    }

    @Override
    public void setArg(Expression expression, int n) throws WrongNumberArgsException {
        if (n < 3) {
            super.setArg(expression, n);
        } else {
            if (null == this.m_args) {
                this.m_args = new Expression[1];
                this.m_args[0] = expression;
            } else {
                Expression[] expressionArray = new Expression[this.m_args.length + 1];
                System.arraycopy(this.m_args, 0, expressionArray, 0, this.m_args.length);
                expressionArray[this.m_args.length] = expression;
                this.m_args = expressionArray;
            }
            expression.exprSetParent(this);
        }
    }

    @Override
    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        if (null != this.m_args) {
            for (int i = 0; i < this.m_args.length; ++i) {
                this.m_args[i].fixupVariables(vector, n);
            }
        }
    }

    @Override
    public void checkNumberArgs(int n) throws WrongNumberArgsException {
    }

    @Override
    protected void reportWrongNumberArgs() throws WrongNumberArgsException {
        String string = XSLMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{"Programmer's assertion:  the method FunctionMultiArgs.reportWrongNumberArgs() should never be called."});
        throw new RuntimeException(string);
    }

    @Override
    public boolean canTraverseOutsideSubtree() {
        if (super.canTraverseOutsideSubtree()) {
            return true;
        }
        int n = this.m_args.length;
        for (int i = 0; i < n; ++i) {
            if (!this.m_args[i].canTraverseOutsideSubtree()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void callArgVisitors(XPathVisitor xPathVisitor) {
        super.callArgVisitors(xPathVisitor);
        if (null != this.m_args) {
            int n = this.m_args.length;
            for (int i = 0; i < n; ++i) {
                this.m_args[i].callVisitors(new ArgMultiOwner(i), xPathVisitor);
            }
        }
    }

    @Override
    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        FunctionMultiArgs functionMultiArgs = (FunctionMultiArgs)expression;
        if (null != this.m_args) {
            int n = this.m_args.length;
            if (null == functionMultiArgs || functionMultiArgs.m_args.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.m_args[i].deepEquals(functionMultiArgs.m_args[i])) continue;
                return false;
            }
        } else if (null != functionMultiArgs.m_args) {
            return false;
        }
        return true;
    }

    class ArgMultiOwner
    implements ExpressionOwner {
        int m_argIndex;

        ArgMultiOwner(int n) {
            this.m_argIndex = n;
        }

        @Override
        public Expression getExpression() {
            return FunctionMultiArgs.this.m_args[this.m_argIndex];
        }

        @Override
        public void setExpression(Expression expression) {
            expression.exprSetParent(FunctionMultiArgs.this);
            FunctionMultiArgs.this.m_args[this.m_argIndex] = expression;
        }
    }
}

