/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.sun.xml.internal.ws.org.objectweb.asm.ClassWriter;
import com.sun.xml.internal.ws.org.objectweb.asm.Label;
import com.sun.xml.internal.ws.org.objectweb.asm.MethodVisitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;
import sun.misc.Unsafe;

class InvokerBytecodeGenerator {
    private static final String MH = "java/lang/invoke/MethodHandle";
    private static final String BMH = "java/lang/invoke/BoundMethodHandle";
    private static final String LF = "java/lang/invoke/LambdaForm";
    private static final String LFN = "java/lang/invoke/LambdaForm$Name";
    private static final String CLS = "java/lang/Class";
    private static final String OBJ = "java/lang/Object";
    private static final String OBJARY = "[Ljava/lang/Object;";
    private static final String LF_SIG = "Ljava/lang/invoke/LambdaForm;";
    private static final String LFN_SIG = "Ljava/lang/invoke/LambdaForm$Name;";
    private static final String LL_SIG = "(Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String superName = "java/lang/invoke/LambdaForm";
    private final String className;
    private final String sourceFile;
    private final LambdaForm lambdaForm;
    private final String invokerName;
    private final MethodType invokerType;
    private final int[] localsMap;
    private ClassWriter cw;
    private MethodVisitor mv;
    private static final MemberName.Factory MEMBERNAME_FACTORY = MemberName.getFactory();
    private static final Class<?> HOST_CLASS = LambdaForm.class;
    private static final HashMap<String, Integer> DUMP_CLASS_FILES_COUNTERS;
    private static final File DUMP_CLASS_FILES_DIR;
    Map<Object, CpPatch> cpPatches = new HashMap<Object, CpPatch>();
    int cph = 0;
    private static Class<?>[] STATICALLY_INVOCABLE_PACKAGES;
    static int nfi;

    private InvokerBytecodeGenerator(LambdaForm lambdaForm, int n, String string, String string2, MethodType methodType) {
        if (string2.contains(".")) {
            int n2 = string2.indexOf(".");
            string = string2.substring(0, n2);
            string2 = string2.substring(n2 + 1);
        }
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            string = InvokerBytecodeGenerator.makeDumpableClassName(string);
        }
        this.className = "java/lang/invoke/LambdaForm$" + string;
        this.sourceFile = "LambdaForm$" + string;
        this.lambdaForm = lambdaForm;
        this.invokerName = string2;
        this.invokerType = methodType;
        this.localsMap = new int[n];
    }

    private InvokerBytecodeGenerator(String string, String string2, MethodType methodType) {
        this(null, methodType.parameterCount(), string, string2, methodType);
        for (int i = 0; i < this.localsMap.length; ++i) {
            this.localsMap[i] = methodType.parameterSlotCount() - methodType.parameterSlotDepth(i);
        }
    }

    private InvokerBytecodeGenerator(String string, LambdaForm lambdaForm, MethodType methodType) {
        this(lambdaForm, lambdaForm.names.length, string, lambdaForm.debugName, methodType);
        LambdaForm.Name[] nameArray = lambdaForm.names;
        int n = 0;
        for (int i = 0; i < this.localsMap.length; ++i) {
            this.localsMap[i] = n;
            n += Wrapper.forBasicType(nameArray[i].type).stackSlots();
        }
    }

    static void maybeDump(final String string, final byte[] byArray) {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            System.out.println("dump: " + string);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        String string2 = string;
                        File file = new File(DUMP_CLASS_FILES_DIR, string2 + ".class");
                        file.getParentFile().mkdirs();
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(byArray);
                        fileOutputStream.close();
                        return null;
                    }
                    catch (IOException iOException) {
                        throw MethodHandleStatics.newInternalError(iOException);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeDumpableClassName(String string) {
        Integer n;
        Object object = DUMP_CLASS_FILES_COUNTERS;
        synchronized (object) {
            n = DUMP_CLASS_FILES_COUNTERS.get(string);
            if (n == null) {
                n = 0;
            }
            DUMP_CLASS_FILES_COUNTERS.put(string, n + 1);
        }
        object = n.toString();
        while (((String)object).length() < 3) {
            object = "0" + (String)object;
        }
        string = string + (String)object;
        return string;
    }

    String constantPlaceholder(Object object) {
        String string = "CONSTANT_PLACEHOLDER_" + this.cph++;
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            string = string + " <<" + object.toString() + ">>";
        }
        if (this.cpPatches.containsKey(string)) {
            throw new InternalError("observed CP placeholder twice: " + string);
        }
        int n = this.cw.newConst(string);
        this.cpPatches.put(string, new CpPatch(n, string, object));
        return string;
    }

    Object[] cpPatches(byte[] byArray) {
        int n = InvokerBytecodeGenerator.getConstantPoolSize(byArray);
        Object[] objectArray = new Object[n];
        for (CpPatch cpPatch : this.cpPatches.values()) {
            if (cpPatch.index >= n) {
                throw new InternalError("in cpool[" + n + "]: " + cpPatch + "\n" + Arrays.toString(Arrays.copyOf(byArray, 20)));
            }
            objectArray[cpPatch.index] = cpPatch.value;
        }
        return objectArray;
    }

    private static int getConstantPoolSize(byte[] byArray) {
        return (byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF;
    }

    private MemberName loadMethod(byte[] byArray) {
        Class<?> clazz = InvokerBytecodeGenerator.loadAndInitializeInvokerClass(byArray, this.cpPatches(byArray));
        return InvokerBytecodeGenerator.resolveInvokerMember(clazz, this.invokerName, this.invokerType);
    }

    private static Class<?> loadAndInitializeInvokerClass(byte[] byArray, Object[] objectArray) {
        Class clazz = MethodHandleStatics.UNSAFE.defineAnonymousClass(HOST_CLASS, byArray, objectArray);
        MethodHandleStatics.UNSAFE.ensureClassInitialized(clazz);
        return clazz;
    }

    private static MemberName resolveInvokerMember(Class<?> clazz, String string, MethodType methodType) {
        MemberName memberName = new MemberName(clazz, string, methodType, 6);
        try {
            memberName = MEMBERNAME_FACTORY.resolveOrFail((byte)6, memberName, HOST_CLASS, ReflectiveOperationException.class);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError(reflectiveOperationException);
        }
        return memberName;
    }

    private void classFilePrologue() {
        this.cw = new ClassWriter(3);
        this.cw.visit(50, 49, this.className, null, "java/lang/invoke/LambdaForm", null);
        this.cw.visitSource(this.sourceFile, null);
        String string = this.invokerType.toMethodDescriptorString();
        this.mv = this.cw.visitMethod(8, this.invokerName, string, null, null);
    }

    private void classFileEpilogue() {
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
    }

    private void emitConst(Object object) {
        double d;
        float f;
        long l;
        if (object == null) {
            this.mv.visitInsn(1);
            return;
        }
        if (object instanceof Integer) {
            this.emitIconstInsn((Integer)object);
            return;
        }
        if (object instanceof Long && (l = ((Long)object).longValue()) == (long)((short)l)) {
            this.emitIconstInsn((int)l);
            this.mv.visitInsn(133);
            return;
        }
        if (object instanceof Float && (f = ((Float)object).floatValue()) == (float)((short)f)) {
            this.emitIconstInsn((int)f);
            this.mv.visitInsn(134);
            return;
        }
        if (object instanceof Double && (d = ((Double)object).doubleValue()) == (double)((short)d)) {
            this.emitIconstInsn((int)d);
            this.mv.visitInsn(135);
            return;
        }
        if (object instanceof Boolean) {
            this.emitIconstInsn((Boolean)object != false ? 1 : 0);
            return;
        }
        this.mv.visitLdcInsn(object);
    }

    private void emitIconstInsn(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 5;
                break;
            }
            case 3: {
                n2 = 6;
                break;
            }
            case 4: {
                n2 = 7;
                break;
            }
            case 5: {
                n2 = 8;
                break;
            }
            default: {
                if (n == (byte)n) {
                    this.mv.visitIntInsn(16, n & 0xFF);
                } else if (n == (short)n) {
                    this.mv.visitIntInsn(17, (char)n);
                } else {
                    this.mv.visitLdcInsn(n);
                }
                return;
            }
        }
        this.mv.visitInsn(n2);
    }

    private void emitLoadInsn(char c, int n) {
        int n2;
        switch (c) {
            case 'I': {
                n2 = 21;
                break;
            }
            case 'J': {
                n2 = 22;
                break;
            }
            case 'F': {
                n2 = 23;
                break;
            }
            case 'D': {
                n2 = 24;
                break;
            }
            case 'L': {
                n2 = 25;
                break;
            }
            default: {
                throw new InternalError("unknown type: " + c);
            }
        }
        this.mv.visitVarInsn(n2, this.localsMap[n]);
    }

    private void emitAloadInsn(int n) {
        this.emitLoadInsn('L', n);
    }

    private void emitStoreInsn(char c, int n) {
        int n2;
        switch (c) {
            case 'I': {
                n2 = 54;
                break;
            }
            case 'J': {
                n2 = 55;
                break;
            }
            case 'F': {
                n2 = 56;
                break;
            }
            case 'D': {
                n2 = 57;
                break;
            }
            case 'L': {
                n2 = 58;
                break;
            }
            default: {
                throw new InternalError("unknown type: " + c);
            }
        }
        this.mv.visitVarInsn(n2, this.localsMap[n]);
    }

    private void emitAstoreInsn(int n) {
        this.emitStoreInsn('L', n);
    }

    private void emitBoxing(Class<?> clazz) {
        Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
        String string = "java/lang/" + wrapper.wrapperType().getSimpleName();
        String string2 = "valueOf";
        String string3 = "(" + wrapper.basicTypeChar() + ")L" + string + ";";
        this.mv.visitMethodInsn(184, string, string2, string3);
    }

    private void emitUnboxing(Class<?> clazz) {
        Wrapper wrapper = Wrapper.forWrapperType(clazz);
        String string = "java/lang/" + wrapper.wrapperType().getSimpleName();
        String string2 = wrapper.primitiveSimpleName() + "Value";
        String string3 = "()" + wrapper.basicTypeChar();
        this.mv.visitTypeInsn(192, string);
        this.mv.visitMethodInsn(182, string, string2, string3);
    }

    private void emitImplicitConversion(char c, Class<?> clazz) {
        switch (c) {
            case 'L': {
                if (VerifyType.isNullConversion(Object.class, clazz)) {
                    return;
                }
                if (InvokerBytecodeGenerator.isStaticallyNameable(clazz)) {
                    this.mv.visitTypeInsn(192, InvokerBytecodeGenerator.getInternalName(clazz));
                } else {
                    this.mv.visitLdcInsn(this.constantPlaceholder(clazz));
                    this.mv.visitTypeInsn(192, CLS);
                    this.mv.visitInsn(95);
                    this.mv.visitMethodInsn(182, CLS, "cast", LL_SIG);
                    if (clazz.isArray()) {
                        this.mv.visitTypeInsn(192, OBJARY);
                    }
                }
                return;
            }
            case 'I': {
                if (!VerifyType.isNullConversion(Integer.TYPE, clazz)) {
                    this.emitPrimCast(c, Wrapper.basicTypeChar(clazz));
                }
                return;
            }
            case 'J': {
                assert (clazz == Long.TYPE);
                return;
            }
            case 'F': {
                assert (clazz == Float.TYPE);
                return;
            }
            case 'D': {
                assert (clazz == Double.TYPE);
                return;
            }
        }
        throw new InternalError("bad implicit conversion: tc=" + c + ": " + clazz);
    }

    private void emitReturnInsn(Class<?> clazz) {
        int n;
        switch (Wrapper.basicTypeChar(clazz)) {
            case 'I': {
                n = 172;
                break;
            }
            case 'J': {
                n = 173;
                break;
            }
            case 'F': {
                n = 174;
                break;
            }
            case 'D': {
                n = 175;
                break;
            }
            case 'L': {
                n = 176;
                break;
            }
            case 'V': {
                n = 177;
                break;
            }
            default: {
                throw new InternalError("unknown return type: " + clazz);
            }
        }
        this.mv.visitInsn(n);
    }

    private static String getInternalName(Class<?> clazz) {
        assert (VerifyAccess.isTypeVisible(clazz, Object.class));
        return clazz.getName().replace('.', '/');
    }

    static MemberName generateCustomizedCode(LambdaForm lambdaForm, MethodType methodType) {
        InvokerBytecodeGenerator invokerBytecodeGenerator = new InvokerBytecodeGenerator("MH", lambdaForm, methodType);
        return invokerBytecodeGenerator.loadMethod(invokerBytecodeGenerator.generateCustomizedCodeBytes());
    }

    private byte[] generateCustomizedCodeBytes() {
        this.classFilePrologue();
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Compiled;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/ForceInline;", true);
        for (int i = this.lambdaForm.arity; i < this.lambdaForm.names.length; ++i) {
            LambdaForm.Name name = this.lambdaForm.names[i];
            MemberName memberName = name.function.member();
            if (this.isSelectAlternative(memberName)) {
                this.emitSelectAlternative(name, this.lambdaForm.names[i + 1]);
                ++i;
            } else if (InvokerBytecodeGenerator.isStaticallyInvocable(memberName)) {
                this.emitStaticInvoke(memberName, name);
            } else {
                this.emitInvoke(name);
            }
            if (i == this.lambdaForm.names.length - 1 && i == this.lambdaForm.result || name.type == 'V') continue;
            this.emitStoreInsn(name.type, name.index());
        }
        this.emitReturn();
        this.classFileEpilogue();
        this.bogusMethod(this.lambdaForm);
        byte[] byArray = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, byArray);
        return byArray;
    }

    void emitInvoke(LambdaForm.Name name) {
        MethodHandle methodHandle = name.function.resolvedHandle;
        assert (methodHandle != null) : name.exprString();
        this.mv.visitLdcInsn(this.constantPlaceholder(methodHandle));
        this.mv.visitTypeInsn(192, MH);
        for (int i = 0; i < name.arguments.length; ++i) {
            this.emitPushArgument(name, i);
        }
        MethodType methodType = name.function.methodType();
        this.mv.visitMethodInsn(182, MH, "invokeBasic", methodType.basicType().toMethodDescriptorString());
    }

    static boolean isStaticallyInvocable(MemberName memberName) {
        if (memberName == null) {
            return false;
        }
        if (memberName.isConstructor()) {
            return false;
        }
        Class<?> clazz = memberName.getDeclaringClass();
        if (clazz.isArray() || clazz.isPrimitive()) {
            return false;
        }
        if (clazz.isAnonymousClass() || clazz.isLocalClass()) {
            return false;
        }
        if (clazz.getClassLoader() != MethodHandle.class.getClassLoader()) {
            return false;
        }
        if (!memberName.isPrivate() && VerifyAccess.isSamePackage(MethodHandle.class, clazz)) {
            return true;
        }
        return memberName.isPublic() && InvokerBytecodeGenerator.isStaticallyNameable(clazz);
    }

    static boolean isStaticallyNameable(Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.getClassLoader() != Object.class.getClassLoader()) {
            return false;
        }
        if (VerifyAccess.isSamePackage(MethodHandle.class, clazz)) {
            return true;
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return false;
        }
        for (Class<?> clazz2 : STATICALLY_INVOCABLE_PACKAGES) {
            if (!VerifyAccess.isSamePackage(clazz2, clazz)) continue;
            return true;
        }
        return false;
    }

    void emitStaticInvoke(MemberName memberName, LambdaForm.Name name) {
        assert (memberName.equals(name.function.member()));
        String string = InvokerBytecodeGenerator.getInternalName(memberName.getDeclaringClass());
        String string2 = memberName.getName();
        byte by = memberName.getReferenceKind();
        if (by == 7) {
            assert (memberName.canBeStaticallyBound()) : memberName;
            by = 5;
        }
        for (int i = 0; i < name.arguments.length; ++i) {
            this.emitPushArgument(name, i);
        }
        if (memberName.isMethod()) {
            String string3 = memberName.getMethodType().toMethodDescriptorString();
            this.mv.visitMethodInsn(this.refKindOpcode(by), string, string2, string3);
        } else {
            String string4 = MethodType.toFieldDescriptorString(memberName.getFieldType());
            this.mv.visitFieldInsn(this.refKindOpcode(by), string, string2, string4);
        }
    }

    int refKindOpcode(byte by) {
        switch (by) {
            case 5: {
                return 182;
            }
            case 6: {
                return 184;
            }
            case 7: {
                return 183;
            }
            case 9: {
                return 185;
            }
            case 1: {
                return 180;
            }
            case 3: {
                return 181;
            }
            case 2: {
                return 178;
            }
            case 4: {
                return 179;
            }
        }
        throw new InternalError("refKind=" + by);
    }

    private boolean isSelectAlternative(MemberName memberName) {
        return memberName != null && memberName.getDeclaringClass() == MethodHandleImpl.class && memberName.getName().equals("selectAlternative");
    }

    private void emitSelectAlternative(LambdaForm.Name name, LambdaForm.Name name2) {
        MethodType methodType = name.function.methodType();
        LambdaForm.Name name3 = (LambdaForm.Name)name2.arguments[0];
        Label label = new Label();
        Label label2 = new Label();
        this.emitPushArgument(name, 0);
        this.mv.visitInsn(4);
        this.mv.visitJumpInsn(160, label);
        MethodHandle methodHandle = (MethodHandle)name.arguments[1];
        this.emitPushArgument(name, 1);
        this.emitAstoreInsn(name3.index());
        this.emitInvoke(name2);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label);
        MethodHandle methodHandle2 = (MethodHandle)name.arguments[2];
        this.emitPushArgument(name, 2);
        this.emitAstoreInsn(name3.index());
        this.emitInvoke(name2);
        this.mv.visitLabel(label2);
    }

    private void emitPushArgument(LambdaForm.Name name, int n) {
        Object object = name.arguments[n];
        char c = name.function.parameterType(n);
        MethodType methodType = name.function.methodType();
        if (object instanceof LambdaForm.Name) {
            LambdaForm.Name name2 = (LambdaForm.Name)object;
            this.emitLoadInsn(name2.type, name2.index());
            this.emitImplicitConversion(name2.type, methodType.parameterType(n));
        } else if ((object == null || object instanceof String) && c == 'L') {
            this.emitConst(object);
        } else if (Wrapper.isWrapperType(object.getClass()) && c != 'L') {
            this.emitConst(object);
        } else {
            this.mv.visitLdcInsn(this.constantPlaceholder(object));
            this.emitImplicitConversion('L', methodType.parameterType(n));
        }
    }

    private void emitReturn() {
        if (this.lambdaForm.result == -1) {
            this.mv.visitInsn(177);
        } else {
            LambdaForm.Name name = this.lambdaForm.names[this.lambdaForm.result];
            char c = Wrapper.basicTypeChar(this.invokerType.returnType());
            if (this.lambdaForm.result != this.lambdaForm.names.length - 1) {
                this.emitLoadInsn(name.type, this.lambdaForm.result);
            }
            if (c != name.type) {
                if (c == 'L') {
                    char c2 = Wrapper.forWrapperType(this.invokerType.returnType()).basicTypeChar();
                    if (c2 != name.type) {
                        this.emitPrimCast(name.type, c2);
                    }
                    this.emitBoxing(this.invokerType.returnType());
                } else if (name.type != 'L') {
                    this.emitPrimCast(name.type, c);
                } else {
                    throw new InternalError("no ref-to-prim (unboxing) casts supported right now");
                }
            }
            this.emitReturnInsn(this.invokerType.returnType());
        }
    }

    private void emitPrimCast(char c, char c2) {
        if (c == c2) {
            return;
        }
        Wrapper wrapper = Wrapper.forBasicType(c);
        Wrapper wrapper2 = Wrapper.forBasicType(c2);
        if (wrapper.isSubwordOrInt()) {
            this.emitI2X(c2);
        } else if (wrapper2.isSubwordOrInt()) {
            this.emitX2I(c);
            if (wrapper2.bitWidth() < 32) {
                this.emitI2X(c2);
            }
        } else {
            boolean bl = false;
            switch (c) {
                case 'J': {
                    if (c2 == 'F') {
                        this.mv.visitInsn(137);
                        break;
                    }
                    if (c2 == 'D') {
                        this.mv.visitInsn(138);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 'F': {
                    if (c2 == 'J') {
                        this.mv.visitInsn(140);
                        break;
                    }
                    if (c2 == 'D') {
                        this.mv.visitInsn(141);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 'D': {
                    if (c2 == 'J') {
                        this.mv.visitInsn(143);
                        break;
                    }
                    if (c2 == 'F') {
                        this.mv.visitInsn(144);
                        break;
                    }
                    bl = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (bl) {
                throw new IllegalStateException("unhandled prim cast: " + c + "2" + c2);
            }
        }
    }

    private void emitI2X(char c) {
        switch (c) {
            case 'B': {
                this.mv.visitInsn(145);
                break;
            }
            case 'S': {
                this.mv.visitInsn(147);
                break;
            }
            case 'C': {
                this.mv.visitInsn(146);
                break;
            }
            case 'I': {
                break;
            }
            case 'J': {
                this.mv.visitInsn(133);
                break;
            }
            case 'F': {
                this.mv.visitInsn(134);
                break;
            }
            case 'D': {
                this.mv.visitInsn(135);
                break;
            }
            case 'Z': {
                this.mv.visitInsn(4);
                this.mv.visitInsn(126);
                break;
            }
            default: {
                throw new InternalError("unknown type: " + c);
            }
        }
    }

    private void emitX2I(char c) {
        switch (c) {
            case 'J': {
                this.mv.visitInsn(136);
                break;
            }
            case 'F': {
                this.mv.visitInsn(139);
                break;
            }
            case 'D': {
                this.mv.visitInsn(142);
                break;
            }
            default: {
                throw new InternalError("unknown type: " + c);
            }
        }
    }

    private static String basicTypeCharSignature(String string, MethodType methodType) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (Class<?> clazz : methodType.parameterList()) {
            stringBuilder.append(Wrapper.forBasicType(clazz).basicTypeChar());
        }
        stringBuilder.append('_').append(Wrapper.forBasicType(methodType.returnType()).basicTypeChar());
        return stringBuilder.toString();
    }

    static MemberName generateLambdaFormInterpreterEntryPoint(String string) {
        assert (LambdaForm.isValidSignature(string));
        char c = LambdaForm.signatureReturn(string);
        MethodType methodType = MethodType.methodType(LambdaForm.typeClass(c), MethodHandle.class);
        int n = LambdaForm.signatureArity(string);
        for (int i = 1; i < n; ++i) {
            methodType = methodType.appendParameterTypes(LambdaForm.typeClass(string.charAt(i)));
        }
        InvokerBytecodeGenerator invokerBytecodeGenerator = new InvokerBytecodeGenerator("LFI", "interpret_" + c, methodType);
        return invokerBytecodeGenerator.loadMethod(invokerBytecodeGenerator.generateLambdaFormInterpreterEntryPointBytes());
    }

    private byte[] generateLambdaFormInterpreterEntryPointBytes() {
        Object object;
        this.classFilePrologue();
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/DontInline;", true);
        this.emitIconstInsn(this.invokerType.parameterCount());
        this.mv.visitTypeInsn(189, OBJ);
        for (int i = 0; i < this.invokerType.parameterCount(); ++i) {
            object = this.invokerType.parameterType(i);
            this.mv.visitInsn(89);
            this.emitIconstInsn(i);
            this.emitLoadInsn(Wrapper.basicTypeChar(object), i);
            if (((Class)object).isPrimitive()) {
                this.emitBoxing((Class<?>)object);
            }
            this.mv.visitInsn(83);
        }
        this.emitAloadInsn(0);
        this.mv.visitFieldInsn(180, MH, "form", LF_SIG);
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(182, "java/lang/invoke/LambdaForm", "interpretWithArguments", "([Ljava/lang/Object;)Ljava/lang/Object;");
        Class<?> clazz = this.invokerType.returnType();
        if (clazz.isPrimitive() && clazz != Void.TYPE) {
            this.emitUnboxing(Wrapper.asWrapperType(clazz));
        }
        this.emitReturnInsn(clazz);
        this.classFileEpilogue();
        this.bogusMethod(this.invokerType);
        object = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, (byte[])object);
        return object;
    }

    static MemberName generateNamedFunctionInvoker(MethodTypeForm methodTypeForm) {
        MethodType methodType = LambdaForm.NamedFunction.INVOKER_METHOD_TYPE;
        String string = InvokerBytecodeGenerator.basicTypeCharSignature("invoke_", methodTypeForm.erasedType());
        InvokerBytecodeGenerator invokerBytecodeGenerator = new InvokerBytecodeGenerator("NFI", string, methodType);
        return invokerBytecodeGenerator.loadMethod(invokerBytecodeGenerator.generateNamedFunctionInvokerImpl(methodTypeForm));
    }

    private byte[] generateNamedFunctionInvokerImpl(MethodTypeForm methodTypeForm) {
        Wrapper wrapper;
        Object object;
        Class<?> clazz;
        MethodType methodType = methodTypeForm.erasedType();
        this.classFilePrologue();
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/ForceInline;", true);
        this.emitAloadInsn(0);
        for (int i = 0; i < methodType.parameterCount(); ++i) {
            this.emitAloadInsn(1);
            this.emitIconstInsn(i);
            this.mv.visitInsn(50);
            clazz = methodType.parameterType(i);
            if (!clazz.isPrimitive()) continue;
            object = methodType.basicType().wrap().parameterType(i);
            wrapper = Wrapper.forBasicType(clazz);
            Wrapper wrapper2 = wrapper.isSubwordOrInt() ? Wrapper.INT : wrapper;
            this.emitUnboxing(wrapper2.wrapperType());
            this.emitPrimCast(wrapper2.basicTypeChar(), wrapper.basicTypeChar());
        }
        String string = methodType.basicType().toMethodDescriptorString();
        this.mv.visitMethodInsn(182, MH, "invokeBasic", string);
        clazz = methodType.returnType();
        if (clazz != Void.TYPE && clazz.isPrimitive()) {
            object = Wrapper.forBasicType(clazz);
            wrapper = ((Wrapper)((Object)object)).isSubwordOrInt() ? Wrapper.INT : object;
            this.emitPrimCast(((Wrapper)((Object)object)).basicTypeChar(), wrapper.basicTypeChar());
            this.emitBoxing(wrapper.primitiveType());
        }
        if (clazz == Void.TYPE) {
            this.mv.visitInsn(1);
        }
        this.emitReturnInsn(Object.class);
        this.classFileEpilogue();
        this.bogusMethod(methodType);
        object = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, object);
        return object;
    }

    private void bogusMethod(Object ... objectArray) {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            this.mv = this.cw.visitMethod(8, "dummy", "()V", null, null);
            for (Object object : objectArray) {
                this.mv.visitLdcInsn(object.toString());
                this.mv.visitInsn(87);
            }
            this.mv.visitInsn(177);
            this.mv.visitMaxs(0, 0);
            this.mv.visitEnd();
        }
    }

    static {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            DUMP_CLASS_FILES_COUNTERS = new HashMap();
            try {
                File file = new File("DUMP_CLASS_FILES");
                if (!file.exists()) {
                    file.mkdirs();
                }
                DUMP_CLASS_FILES_DIR = file;
                System.out.println("Dumping class files to " + DUMP_CLASS_FILES_DIR + "/...");
            }
            catch (Exception exception) {
                throw MethodHandleStatics.newInternalError(exception);
            }
        } else {
            DUMP_CLASS_FILES_COUNTERS = null;
            DUMP_CLASS_FILES_DIR = null;
        }
        STATICALLY_INVOCABLE_PACKAGES = new Class[]{Object.class, Arrays.class, Unsafe.class};
        nfi = 0;
    }

    class CpPatch {
        final int index;
        final String placeholder;
        final Object value;

        CpPatch(int n, String string, Object object) {
            this.index = n;
            this.placeholder = string;
            this.value = object;
        }

        public String toString() {
            return "CpPatch/index=" + this.index + ",placeholder=" + this.placeholder + ",value=" + this.value;
        }
    }
}

