/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.rabbitmq.collect;

import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.rabbitmq.collect.RabbitStatsCollector;
import org.hyperic.hq.plugin.rabbitmq.core.HypericRabbitAdmin;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitChannel;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitStatsObject;

public class ChannelCollector
extends RabbitStatsCollector {
    private static final Log logger = LogFactory.getLog(ChannelCollector.class);

    public RabbitStatsObject collectStats(HypericRabbitAdmin rabbitAdmin) {
        Properties props = this.getProperties();
        String chName = props.getProperty("channel");
        logger.debug((Object)("[collect] RabbitChannel=" + chName));
        RabbitChannel res = null;
        try {
            RabbitChannel c = rabbitAdmin.getChannel(chName);
            this.setAvailability(c.getIdleSince() == null ? 1.0 : -0.01);
            this.setValue("idleTime", c.getIdleSince() == null ? 0.0 : (double)(new Date().getTime() - c.getIdleSince().getTime()));
            this.setValue("consumerCount", c.getConsumerCount());
            this.setValue("prefetchCount", c.getPrefetchCount());
            this.setValue("acksUncommitted", c.getAcksUncommitted());
            this.setValue("messagesUnacknowledged", c.getMessagesUnacknowledged());
            res = c;
        }
        catch (Exception ex) {
            this.setAvailability(false);
            logger.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        return res;
    }

    public Log getLog() {
        return logger;
    }
}

