/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.rabbitmq.collect;

import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.rabbitmq.collect.RabbitStatsCollector;
import org.hyperic.hq.plugin.rabbitmq.core.HypericRabbitAdmin;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitQueue;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitStatsObject;

public class QueueCollector
extends RabbitStatsCollector {
    private static final Log logger = LogFactory.getLog(QueueCollector.class);

    public RabbitStatsObject collectStats(HypericRabbitAdmin rabbitAdmin) {
        Properties props = this.getProperties();
        String vhost = (String)props.get("vhost");
        String queue = (String)props.get("queue");
        if (logger.isDebugEnabled()) {
            String node = (String)props.get("node");
            logger.debug((Object)("[collect] queue='" + queue + "' vhost='" + vhost + "' node='" + node + "'"));
        }
        RabbitQueue res = null;
        try {
            HypericRabbitAdmin admin = new HypericRabbitAdmin(props);
            RabbitQueue q = admin.getVirtualQueue(vhost, queue);
            this.setAvailability(q.getIdleSince() == null ? 1.0 : -0.01);
            this.setValue("idleTime", q.getIdleSince() == null ? 0.0 : (double)(new Date().getTime() - q.getIdleSince().getTime()));
            this.setValue("messages", q.getMessages());
            this.setValue("consumers", q.getConsumers());
            this.setValue("messagesReady", q.getMessagesReady());
            this.setValue("messagesUnacknowledged", q.getMessagesUnacknowledged());
            this.setValue("memory", q.getMemory());
            res = q;
        }
        catch (Exception ex) {
            this.setAvailability(false);
            logger.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        return res;
    }

    public Log getLog() {
        return logger;
    }
}

