/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.rabbitmq.collect;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.rabbitmq.collect.RabbitStatsCollector;
import org.hyperic.hq.plugin.rabbitmq.core.HypericRabbitAdmin;
import org.hyperic.hq.plugin.rabbitmq.core.QueueTotals;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitNode;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitOverview;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitStatsObject;
import org.hyperic.hq.product.PluginException;

public class RabbitServerCollector
extends RabbitStatsCollector {
    private static final Log logger = LogFactory.getLog(RabbitServerCollector.class);

    public RabbitStatsObject collectStats(HypericRabbitAdmin rabbitAdmin) {
        Properties props = this.getProperties();
        String node = (String)props.get("node");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[collect] node=" + node));
        }
        RabbitOverview res = null;
        try {
            RabbitNode n = rabbitAdmin.getNode(node);
            RabbitOverview o = rabbitAdmin.getOverview();
            this.setAvailability(n.isRunning());
            this.setValue("mem_ets", n.getMemEts());
            this.setValue("proc_used", n.getProcUsed());
            this.setValue("proc_used_percentage", (double)n.getProcUsed() / (double)n.getProcTotal());
            this.setValue("fd_percentage", (double)n.getFdUsed() / (double)n.getFdTotal());
            this.setValue("connectionCount", rabbitAdmin.getConnections().size());
            this.setValue("channelCount", rabbitAdmin.getChannels().size());
            QueueTotals queueTotals = o.getQueueTotals();
            if (queueTotals != null) {
                this.setValue("messages", queueTotals.getMessages());
                this.setValue("messages_ready", queueTotals.getMessagesReady());
                this.setValue("messages_unacknowledged", queueTotals.getMessagesUnacknowledged());
            }
            res = o;
        }
        catch (PluginException ex) {
            this.setAvailability(false);
            logger.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        return res;
    }

    public Log getLog() {
        return logger;
    }
}

