/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss;

import org.hyperic.hq.plugin.jboss.JBossUtil;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;

public class JBossMeasurementPlugin
extends MeasurementPlugin {
    static final String ATTR_STATE = "StateString";
    static final String ATTR_STATE_MANAGEABLE = "StateManageable";
    static final String ATTR_STATISTIC = "Statistic";

    private boolean isStateManageable(String attr) {
        return attr.equalsIgnoreCase(ATTR_STATE_MANAGEABLE);
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        Object obj;
        try {
            obj = JBossUtil.getRemoteMBeanValue(metric);
        }
        catch (MetricUnreachableException e) {
            if (metric.getAttributeName().equals(ATTR_STATE) || this.isStateManageable(metric.getAttributeName())) {
                return new MetricValue(0.0);
            }
            throw e;
        }
        double val = metric.getAttributeName().equals(ATTR_STATE) ? (obj.equals("Started") ? 1.0 : 0.0) : (this.isStateManageable(metric.getAttributeName()) ? (obj != null ? 1.0 : 0.0) : (obj instanceof Boolean ? (obj.equals(Boolean.TRUE) ? 1.0 : 0.0) : Double.valueOf(obj.toString())));
        return new MetricValue(val);
    }
}

