/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss;

import java.io.File;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import org.hyperic.hq.plugin.jboss.JBossProductPlugin;
import org.hyperic.hq.plugin.jboss.JBossUtil;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerControlPlugin;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public class JBossServerControlPlugin
extends ServerControlPlugin {
    protected static final int TIMEOUT = 600;
    public static final String PROP_CONFIGSET = "configSet";
    static final String PROP_STOP_PROGRAM = "stop.program";
    static final String PROP_STOP_ARGS = "stop.args";
    static final String PROP_START_ARGS = "start.args";
    private static final String SERVER = "jboss.system:type=Server";
    private String configSet = null;
    private Metric serverMetric = null;
    private boolean isStopProgramAction = false;

    public JBossServerControlPlugin() {
        this.setTimeout(600);
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        String val = config.getValue(PROP_CONFIGSET);
        if (val == null) {
            this.getLog().error((Object)("Can't find server name in config response " + config));
            throw new PluginException("no server name configured");
        }
        this.configSet = val;
    }

    private Metric configureMetric(String template) {
        String metric = Metric.translate((String)template, (ConfigResponse)this.getConfig());
        try {
            return Metric.parse((String)metric);
        }
        catch (Exception e) {
            this.getLog().error((Object)("Metric parsing error: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private String getConfigSet() {
        return this.configSet;
    }

    private Metric getServerMetric() {
        if (this.serverMetric == null) {
            String metric = "jboss.system:type=Server:Version:" + this.getPluginProperty("template-config");
            this.serverMetric = this.configureMetric(metric);
        }
        return this.serverMetric;
    }

    protected boolean isRunning() {
        try {
            JBossUtil.getMBeanServerConnection(this.getConfig().toProperties());
            return true;
        }
        catch (NamingException e) {
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    protected File getWorkingDirectory() {
        return new File(this.getInstallPrefix(), "bin");
    }

    protected boolean isBackgroundCommand() {
        return !this.isStopProgramAction;
    }

    static String getControlScript(boolean isWin32) {
        String ext;
        String sep;
        if (isWin32) {
            sep = "\\";
            ext = "bat";
        } else {
            sep = "/";
            ext = "sh";
        }
        return "bin" + sep + "run." + ext;
    }

    protected void getServerConfigSchema(TypeInfo info, ConfigSchema schema, ConfigResponse response) {
        String tok;
        String servers;
        boolean isWin32 = this.getTypeInfo().isWin32Platform();
        this.setControlProgram(JBossServerControlPlugin.getControlScript(isWin32));
        super.getServerConfigSchema(info, schema, response);
        String installpath = response.getValue("installpath", this.getDefaultInstallPath());
        String sep = isWin32 ? "\\" : "/";
        int ix = installpath.lastIndexOf(sep);
        if (ix != -1 && (servers = installpath.substring(0, ix)).endsWith(tok = sep + "servers")) {
            installpath = servers.substring(0, servers.length() - tok.length());
        }
        schema.setDefault("program", installpath + sep + this.getControlProgram());
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigSchema schema = super.getConfigSchema(info, config);
        ConfigOption opt = schema.getOption("program");
        opt.setDescription("Server start program");
        schema.addOptionAsFirst(opt);
        return schema;
    }

    protected String[] getCommandEnv() {
        return new String[]{"JBOSS_HOME=" + this.getJBossHome(), "NOPAUSE=true"};
    }

    private boolean isBrandedServer() {
        if (JBossProductPlugin.isBrandedServer(new File(this.getInstallPrefix()), this.getPluginProperty("brand.ear"))) {
            this.setResult(-1);
            this.setMessage("Control not supported for " + this.getPluginProperty("brand.name"));
            return true;
        }
        return false;
    }

    private String[] getProgramArgs(String prop) {
        String cmdline = this.getConfig(prop);
        if (cmdline == null || cmdline.length() == 0) {
            return null;
        }
        return StringUtil.explodeQuoted((String)cmdline);
    }

    public void start() {
        if (this.isBrandedServer()) {
            return;
        }
        String[] args = this.getProgramArgs(PROP_START_ARGS);
        if (args == null) {
            String _config = this.getConfigSet();
            args = _config == null || _config.length() == 0 ? new String[]{} : new String[]{"-c", _config};
        }
        this.doCommand(this.getControlProgram(), args);
        this.handleResult("started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isBrandedServer()) {
            return;
        }
        String program = this.getConfig(PROP_STOP_PROGRAM);
        if (program == null || program.length() == 0) {
            this.invokeMethod("shutdown");
            if (this.getResult() == 0) {
                this.setMessage("Server stopped via JMX");
            }
        } else {
            String cmdline = this.getConfig(PROP_STOP_ARGS);
            String[] args = StringUtil.explodeQuoted((String)cmdline);
            this.isStopProgramAction = true;
            try {
                this.doCommand(program, args);
            }
            finally {
                this.isStopProgramAction = false;
            }
        }
        this.handleResult("stopped");
    }

    public void restart() {
        if (this.isBrandedServer()) {
            return;
        }
        boolean hadToStop = false;
        if (this.isRunning()) {
            hadToStop = true;
            this.stop();
        }
        if (!hadToStop || this.getResult() == 0) {
            this.start();
        }
    }

    public void runGarbageCollector() {
        this.invokeMethod("runGarbageCollector");
    }

    private void invokeMethod(String action) {
        try {
            JBossUtil.invoke(this.getServerMetric(), action);
            this.setResult(0);
        }
        catch (MetricNotFoundException e) {
            this.setMessage(e.getMessage());
            this.setResult(-1);
        }
        catch (MetricUnreachableException e) {
            this.setMessage(e.getMessage());
            this.setResult(-1);
        }
        catch (PluginException e) {
            if (action.equals("shutdown") && !this.isRunning()) {
                this.setResult(0);
            }
            this.setMessage(e.getMessage());
            this.setResult(-1);
        }
    }

    private String getJBossHome() {
        File server = new File(this.getInstallPrefix());
        File home = server.getParentFile().getParentFile();
        return home.getPath();
    }
}

