/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss.jmx;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hyperic.hq.plugin.jboss.jmx.ServiceQuery;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.ProductPluginManager;

class GenericServiceQuery
extends ServiceQuery {
    private String type;
    private Map props;
    private ArrayList names;

    GenericServiceQuery() {
    }

    void setType(String type) {
        this.type = type;
    }

    String getMBeanClass() {
        return this.getProperty("MBEAN_CLASS");
    }

    public ServiceQuery cloneInstance() {
        GenericServiceQuery query = (GenericServiceQuery)super.cloneInstance();
        query.type = this.type;
        query.props = this.props;
        query.names = this.names;
        return query;
    }

    protected String getProperty(String name) {
        return this.getServerDetector().getTypeProperty(this.type, name);
    }

    private StringBuffer appendComma(StringBuffer buf) {
        char c = buf.charAt(buf.length() - 1);
        if (c != ',' && c != ':') {
            buf.append(',');
        }
        return buf;
    }

    private boolean isAutoValue(String val) {
        return (val.startsWith("%") || val.startsWith("_%")) && val.endsWith("%");
    }

    private boolean isOptionalValue(String val) {
        return val.startsWith("_");
    }

    private ObjectName getObjectNameProperty() {
        ObjectName oName;
        String name = this.getProperty("OBJECT_NAME");
        if (name == null) {
            String msg = this.type + " service did not define property " + "OBJECT_NAME";
            throw new IllegalArgumentException(msg);
        }
        this.names = new ArrayList();
        try {
            oName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            String msg = this.type + " service defined malformed " + "OBJECT_NAME" + "=" + name + " (" + e.getMessage() + ")";
            throw new IllegalArgumentException(msg);
        }
        Hashtable<String, String> _props = oName.getKeyPropertyList();
        for (Map.Entry entry : _props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (!this.isAutoValue(val)) continue;
            this.names.add(key);
        }
        return oName;
    }

    public String getQueryName() {
        ObjectName name = this.getObjectNameProperty();
        StringBuffer buf = new StringBuffer();
        buf.append(name.getDomain()).append(":");
        boolean isPattern = false;
        this.props = name.getKeyPropertyList();
        Iterator it = this.props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (this.isAutoValue(val)) {
                if (this.isOptionalValue(val)) {
                    this.props.put(key, "?");
                } else {
                    this.props.put(key, "*");
                }
                isPattern = true;
            } else {
                buf.append(key).append('=').append(val);
            }
            if (!it.hasNext()) continue;
            this.appendComma(buf);
        }
        if (isPattern) {
            this.appendComma(buf).append('*');
        }
        return buf.toString();
    }

    public boolean apply(ObjectName name) {
        Hashtable<String, String> _props = name.getKeyPropertyList();
        if (this.props.size() != _props.size()) {
            return false;
        }
        for (Map.Entry entry : this.props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            String compare = (String)_props.get(key);
            if (compare == null && !val.equals("?")) {
                return false;
            }
            if (val.equals("*") || val.equals("?") || val.equals(compare)) continue;
            return false;
        }
        return true;
    }

    public String getServiceResourceType() {
        return this.getServerDetector().getTypeNameProperty(this.type);
    }

    protected String getPropertyName() {
        return "name";
    }

    public Properties getResourceConfig() {
        ObjectName name = this.getObjectName();
        Properties config = new Properties();
        for (String key : this.props.keySet()) {
            String val;
            if (!this.props.get(key).equals("*") && !this.props.get(key).equals("?") || (val = name.getKeyProperty(key)) == null) continue;
            config.setProperty(key, val);
        }
        return config;
    }

    public String getName() {
        ObjectName oName = this.getObjectName();
        if (oName == null) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        Iterator it = this.names.iterator();
        while (it.hasNext()) {
            String n = oName.getKeyProperty((String)it.next());
            if (n == null) continue;
            name.append(n);
            if (!it.hasNext()) continue;
            name.append(' ');
        }
        return name.toString();
    }

    public boolean hasControl() {
        ProductPluginManager ppm = (ProductPluginManager)this.getServerDetector().getManager().getParent();
        ControlPlugin plugin = ppm.getControlPlugin(this.type);
        return plugin != null;
    }
}

