/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss7;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.jboss7.JBoss7DefaultCollector;
import org.hyperic.hq.plugin.jboss7.JBossAdminHttp;
import org.hyperic.hq.plugin.jboss7.objects.Connector;
import org.hyperic.hq.product.PluginException;

public class ConnectorCollector
extends JBoss7DefaultCollector {
    private static final Log log = LogFactory.getLog(ConnectorCollector.class);

    public void collect(JBossAdminHttp admin) {
        String connector = (String)this.getProperties().get("connector");
        try {
            Connector c = admin.getConnector(connector);
            this.setAvailability(true);
            this.setValue("bytesReceived", c.getBytesReceived());
            this.setValue("bytesSent", c.getBytesSent());
            this.setValue("errorCount", c.getErrorCount());
            this.setValue("maxTime", c.getMaxTime());
            this.setValue("processingTime", c.getProcessingTime());
            this.setValue("requestCount", c.getRequestCount());
        }
        catch (PluginException ex) {
            this.setAvailability(false);
            log.debug((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public Log getLog() {
        return log;
    }
}

