/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss7;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.jboss7.JBossAdminHttp;
import org.hyperic.hq.plugin.jboss7.JBossHostControllerCollector;
import org.hyperic.hq.plugin.jboss7.objects.TransactionsStats;
import org.hyperic.hq.product.PluginException;

public class JBoss7Collector
extends JBossHostControllerCollector {
    private static final Log log = LogFactory.getLog(JBoss7Collector.class);

    public void collect(JBossAdminHttp admin) {
        super.collect(admin);
        try {
            TransactionsStats ts = admin.getTransactionsStats();
            this.setValue("aborted-transactions", ts.getAbortedTransactions());
            this.setValue("application-rollbacks", ts.getApplicationRollbacks());
            this.setValue("committed-transactions", ts.getCommittedTransactions());
            this.setValue("heuristics", ts.getHeuristics());
            this.setValue("inflight-transactions", ts.getInflightTransactions());
            this.setValue("nested-transactions", ts.getNestedTransactions());
            this.setValue("resource-rollbacks", ts.getResourceRollbacks());
            this.setValue("timed-out-transactions", ts.getTimedOutTransactions());
            this.setValue("transactions", ts.getTransactions());
        }
        catch (PluginException ex) {
            log.debug((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public Log getLog() {
        return log;
    }
}

