/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss7;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.jboss7.JBoss7DefaultCollector;
import org.hyperic.hq.plugin.jboss7.JBossAdminHttp;
import org.hyperic.hq.plugin.jboss7.objects.ServerMemory;
import org.hyperic.hq.plugin.jboss7.objects.ThreadsInfo;
import org.hyperic.hq.product.PluginException;

public class JBossHostControllerCollector
extends JBoss7DefaultCollector {
    private static final Log log = LogFactory.getLog(JBossHostControllerCollector.class);

    public void collect(JBossAdminHttp admin) {
        try {
            this.setAvailability(true);
            ThreadsInfo th = admin.getThreadsInfo();
            this.setValue("thread-count", th.getThreadCount());
            this.setValue("peak-thread-count", th.getPeakThreadCount());
            this.setValue("total-started-thread-count", th.getTotalStartedThreadCount());
            this.setValue("daemon-thread-count", th.getDaemonThreadCount());
            this.setValue("current-thread-cpu-time", th.getCurrentThreadCpuTime());
            this.setValue("current-thread-user-time", th.getCurrentThreadUserTime());
        }
        catch (PluginException ex) {
            this.setAvailability(false);
            log.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        try {
            ServerMemory sm = admin.getServerMemory();
            this.setValue("h.used.p", sm.getHeapMemoryUsage().getUsedPercentage());
            this.setValue("h.init", sm.getHeapMemoryUsage().getInit());
            this.setValue("h.used", sm.getHeapMemoryUsage().getUsed());
            this.setValue("h.committed", sm.getHeapMemoryUsage().getCommitted());
            this.setValue("h.max", sm.getHeapMemoryUsage().getMax());
            this.setValue("nh.used.p", sm.getNonHeapMemoryUsage().getUsedPercentage());
            this.setValue("nh.init", sm.getNonHeapMemoryUsage().getInit());
            this.setValue("nh.used", sm.getNonHeapMemoryUsage().getUsed());
            this.setValue("nh.committed", sm.getNonHeapMemoryUsage().getCommitted());
            this.setValue("nh.max", sm.getNonHeapMemoryUsage().getMax());
        }
        catch (PluginException ex) {
            log.debug((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public Log getLog() {
        return log;
    }
}

