/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.oc4j;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.jmx.MxServerDetector;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public class Oc4jServerDetector
extends MxServerDetector {
    private static final Log log = LogFactory.getLog((String)Oc4jServerDetector.class.getName());
    private static final String OC4J_JAR = "oc4j.jar";
    private static final String J2EE_HOME = "j2ee" + File.separator + "home";
    private static final String RMI_XML = J2EE_HOME + File.separator + "config" + File.separator + "rmi.xml";
    private static final String OPMN_XML = "opmn" + File.separator + "conf" + File.separator + "opmn.xml";
    private static final String OC4J_JMX_URL_BASE = "service:jmx:rmi://localhost:";
    private static final String OPMN_JMX_URL_BASE = "service:jmx:rmi:///opmn://localhost:";
    private static final Pattern RMI_PORT_PATTERN = Pattern.compile(".*\\s*port\\s*=\"(.*)\".*");
    private static final Pattern OPMN_PORT_PATTERN = Pattern.compile(".*\\s*request\\s*=\"(.*)\".*");

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        List procs = this.getServerProcessList();
        for (int i = 0; i < procs.size(); ++i) {
            ConfigOption option;
            MxServerDetector.MxProcess process = (MxServerDetector.MxProcess)procs.get(i);
            String dir = process.getInstallPath();
            if (!this.isInstallTypeVersion(dir)) continue;
            ServerResource server = this.createServerResource(dir);
            this.adjustClassPath(dir);
            ConfigResponse config = new ConfigResponse();
            ConfigSchema schema = this.getConfigSchema(this.getTypeInfo().getName(), 0);
            if (schema != null && (option = schema.getOption("process.query")) != null) {
                String query = "State.Name.sw=java,Args.*.ct=oc4j.jar";
                config.setValue(option.getName(), query);
            }
            if (process.getURL() != null) {
                config.setValue("jmx.url", process.getURL());
            }
            this.setProductConfig(server, config);
            String name = this.formatAutoInventoryName(server.getType(), platformConfig, server.getProductConfig(), new ConfigResponse());
            if (name != null) {
                server.setName(name);
            }
            server.setMeasurementConfig();
            servers.add(server);
        }
        return servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJMXUrl(String dir, String instanceName) {
        Pattern pattern;
        String sourceFile;
        BufferedReader in = null;
        String port = null;
        if (instanceName == null) {
            sourceFile = dir + File.separator + RMI_XML;
            pattern = RMI_PORT_PATTERN;
        } else {
            sourceFile = dir + File.separator + OPMN_XML;
            pattern = OPMN_PORT_PATTERN;
        }
        try {
            String str;
            in = new BufferedReader(new FileReader(sourceFile));
            while ((str = in.readLine()) != null) {
                Matcher matcher = pattern.matcher(str);
                if (!matcher.matches()) continue;
                port = matcher.group(1);
                if (pattern == RMI_PORT_PATTERN) {
                    log.debug((Object)("Auto-detected JMX RMI port to " + port));
                } else if (pattern == OPMN_PORT_PATTERN) {
                    log.debug((Object)("Auto-detected JMX OPMN port to " + port));
                }
                break;
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to detect JMX URI port in file " + sourceFile), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Failed to close file " + sourceFile), (Throwable)e);
                }
            }
        }
        String url = instanceName == null ? OC4J_JMX_URL_BASE + port : OPMN_JMX_URL_BASE + port + "/" + instanceName;
        return url;
    }

    protected List getServerProcessList() {
        ArrayList<Oc4jProcess> procs = new ArrayList<Oc4jProcess>();
        String procQuery = "State.Name.sw=java,Args.*.ct=oc4j.jar";
        long[] pids = Oc4jServerDetector.getPids((String)procQuery);
        log.debug((Object)(procQuery + " matched " + pids.length + " processes"));
        for (int i = 0; i < pids.length; ++i) {
            long pid = pids[i];
            String[] args = Oc4jServerDetector.getProcArgs((long)pid);
            String path = null;
            String instanceName = null;
            for (int j = 1; j < args.length; ++j) {
                String arg = args[j];
                if (arg.endsWith(OC4J_JAR) && args[j - 1].equals("-jar")) {
                    File jar = new File(arg);
                    if (jar.exists()) {
                        path = jar.getAbsolutePath();
                    } else {
                        jar = new File(Oc4jServerDetector.getProcCwd((long)pid) + File.separator + arg);
                        if (jar.exists()) {
                            path = jar.getAbsolutePath();
                        }
                    }
                    if (path != null) {
                        log.debug((Object)("Got path for oc4j.jar: " + path));
                        int index = path.lastIndexOf(J2EE_HOME + File.separator + OC4J_JAR);
                        path = path.substring(0, index - 1);
                        break;
                    }
                }
                if (!arg.startsWith("-Doracle.oc4j.instancename=")) continue;
                instanceName = StringUtil.replace((String)arg, (String)"-Doracle.oc4j.instancename=", (String)"");
                log.debug((Object)("Auto-detected OC4J instance " + instanceName));
            }
            if (path == null) continue;
            Oc4jProcess process = new Oc4jProcess(pid, args, path);
            process.setURL(this.getJMXUrl(process.getInstallPath(), instanceName));
            procs.add(process);
        }
        return procs;
    }

    protected class Oc4jProcess
    extends MxServerDetector.MxProcess {
        protected Oc4jProcess(long pid, String[] args, String installpath) {
            super(pid, args, installpath);
        }
    }
}

