/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.tomcat;

import java.io.File;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.ProcessFinder;

public class TomcatProductPlugin
extends ProductPlugin {
    public String[] getClassPath(ProductPluginManager manager) {
        String from;
        String prop = "jbossweb.installpath";
        String sysval = System.getProperty(prop);
        String installDir = manager.getProperties().getProperty(prop, sysval);
        if (installDir == null) {
            installDir = this.getRunningInstallPath();
            from = "running process";
        } else {
            from = "properties";
        }
        String[] classpath = super.getClassPath(manager);
        if (installDir == null) {
            this.getLog().debug((Object)(prop + " not configured"));
            return classpath;
        }
        this.getLog().debug((Object)("Setting " + prop + "=" + installDir + ", configured from " + from));
        for (int i = 0; i < classpath.length; ++i) {
            File jar = new File(installDir, classpath[i]);
            if (!jar.exists()) continue;
            classpath[i] = jar.getPath();
        }
        return classpath;
    }

    private String getRunningInstallPath() {
        String res = null;
        try {
            Sigar sigar = new Sigar();
            long[] pids = ProcessFinder.find((Sigar)sigar, (String)"State.Name.re=java|jsvc,State.Name.Pne=jsvc,Args.*.eq=org.jboss.Main");
            if (pids.length > 0) {
                res = new File(sigar.getProcExe(pids[0]).getCwd()).getParent();
            }
        }
        catch (SigarException ex) {
            this.getLog().debug((Object)("[getRunningInstallPath] " + ex.getMessage()), (Throwable)ex);
            res = null;
        }
        return res;
    }
}

