/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.iis;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.Win32MeasurementPlugin;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.http.HQHttpClient;
import org.hyperic.util.http.HttpConfig;
import org.hyperic.util.security.KeystoreConfig;

public class IisMeasurementPlugin
extends Win32MeasurementPlugin {
    private Log log = LogFactory.getLog(IisMeasurementPlugin.class);
    private static String SERVER_HOSTNAME = "_Total";
    public static String PROP_IISHOST = "iishost";

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        MetricValue res = MetricValue.NONE;
        res = metric.getDomainName().equalsIgnoreCase("web") ? this.testWebServer(metric) : super.getValue(metric);
        return res;
    }

    private MetricValue testWebServer(Metric metric) throws PluginException {
        double res = 0.0;
        Properties props = metric.getObjectProperties();
        int port = Integer.parseInt(props.getProperty("port"));
        String addr = props.getProperty("hostname");
        String path = props.getProperty("path");
        boolean https = "true".equals(props.getProperty("ssl"));
        HttpHost targetHost = new HttpHost(addr, port, https ? "https" : "http");
        HttpGet get = new HttpGet(targetHost.toURI() + path);
        AgentKeystoreConfig ksConfig = new AgentKeystoreConfig();
        HQHttpClient client = new HQHttpClient((KeystoreConfig)ksConfig, new HttpConfig(5000, 5000, null, 0), ksConfig.isAcceptUnverifiedCert());
        try {
            HttpResponse response = client.execute((HttpUriRequest)get, (HttpContext)new BasicHttpContext());
            int r = response.getStatusLine().getStatusCode();
            this.log.debug((Object)("[testWebServer] url='" + get.getURI() + "' statusCode='" + r + "'"));
            res = 1.0;
        }
        catch (IOException ex) {
            this.log.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        return new MetricValue(res);
    }

    public String translate(String template, ConfigResponse config) {
        if (config.getValue(PROP_IISHOST) == null) {
            config.setValue(PROP_IISHOST, SERVER_HOSTNAME);
        }
        template = StringUtil.replace((String)template, (String)("${" + PROP_IISHOST + "}"), (String)config.getValue(PROP_IISHOST));
        return super.translate(template, config);
    }
}

