/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfws;

import com.vmware.vfabric.hyperic.plugin.vfws.BmxResult;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class BmxQuery {
    private static final String _logCtx = BmxQuery.class.getName();
    private static final Log _log = LogFactory.getLog((String)_logCtx);
    private URL _url;
    private BmxResult _result;

    public BmxQuery(URL url) {
        this.setURL(url);
    }

    public void setURL(URL url) {
        this._url = url;
    }

    public URL getURL() {
        return this._url;
    }

    public BmxResult getResult() {
        this.doQuery();
        return this._result;
    }

    private void doQuery() {
        HttpGet method;
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            _log.debug((Object)("Getting URL " + this.getURL().toURI().toString()));
            method = new HttpGet(this.getURL().toURI());
        }
        catch (URISyntaxException e) {
            _log.debug((Object)e, (Throwable)e);
            return;
        }
        method.getParams().setParameter("http.protocol.handle-redirects", (Object)true);
        try {
            HttpResponse response = client.execute((HttpUriRequest)method);
            this._result = new BmxResult(response);
            _log.debug((Object)("Got " + response.getStatusLine().getStatusCode() + " from " + this.getURL().toString()));
        }
        catch (IOException e) {
            _log.debug((Object)e, (Throwable)e);
        }
    }
}

