/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.springsource.hyperic.plugin.gemfire.collectors;

import com.vmware.springsource.hyperic.plugin.gemfire.GemFireLiveData;
import com.vmware.springsource.hyperic.plugin.gemfire.GemFireUtils;
import com.vmware.springsource.hyperic.plugin.gemfire.detectors.GemfirePlatformDetector;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxUtil;

public class GemfireCollector
extends Collector {
    static Log log = LogFactory.getLog(GemfireCollector.class);
    String last_signature = "";

    protected void init() throws PluginException {
        Properties props = this.getProperties();
        log.debug((Object)("[init] props=" + props));
        super.init();
    }

    public void collect() {
        int a = 0;
        int c = 0;
        int g = 0;
        Properties props = this.getProperties();
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)props);
            String id = GemFireLiveData.getSystemID(mServer);
            List<String> members = GemFireUtils.getMembers(mServer);
            String signature = Arrays.asList(members).toString();
            if (!signature.equals(this.last_signature)) {
                this.last_signature = signature;
                GemfirePlatformDetector.runAutoDiscovery(id);
                GemFireUtils.clearNameCache();
            }
            for (String memberID : members) {
                Map<String, Object> memberDetails = GemFireUtils.getMemberDetails(memberID, mServer);
                if ("true".equalsIgnoreCase(memberDetails.get("gemfire.member.isgateway.boolean").toString())) {
                    ++g;
                    continue;
                }
                if ("true".equalsIgnoreCase(memberDetails.get("gemfire.member.isserver.boolean").toString())) {
                    ++c;
                    continue;
                }
                ++a;
            }
            this.setAvailability(true);
            this.setValue("n_gateways", new Double(g));
            this.setValue("n_apps", new Double(a));
            this.setValue("n_caches", new Double(c));
        }
        catch (Exception ex) {
            this.setAvailability(false);
            log.debug((Object)("[collect] " + ex.getMessage()), (Throwable)ex);
        }
    }
}

