/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.springsource.hyperic.plugin.gemfire.collectors;

import com.vmware.springsource.hyperic.plugin.gemfire.GemFireUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxUtil;

public class MemberCollector
extends Collector {
    static Log log = LogFactory.getLog(MemberCollector.class);
    private static final int prefixLength = "gemfire.member.".length();
    static Map cpu_cache = new HashMap();

    protected void init() throws PluginException {
        Properties props = this.getProperties();
        log.debug((Object)("[init] props=" + props));
        super.init();
    }

    public void collect() {
        Properties props = this.getProperties();
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)props);
            String memberID = GemFireUtils.memberNameToMemberID(props.getProperty("member.name"), mServer);
            this.addValues(MemberCollector.getMetrics(memberID, mServer, false));
            this.setAvailability(true);
        }
        catch (Exception ex) {
            this.setAvailability(false);
            log.debug((Object)("[collect] " + ex.getMessage()), (Throwable)ex);
        }
    }

    public static Map getMetrics(String memberID, MBeanServerConnection mServer, boolean hqu) throws PluginException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        Map<String, Object> memberDetails = GemFireUtils.getMemberDetails(memberID, mServer);
        for (String k : memberDetails.keySet()) {
            res.put(k.substring(prefixLength, k.lastIndexOf(46)), memberDetails.get(k));
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("[getMetrics] " + k + "=" + memberDetails.get(k)));
        }
        Long max = (Long)res.get("stat.maxmemory");
        Long used = (Long)res.get("stat.usedmemory");
        if (max != null && used != null) {
            res.put("used_memory", (double)used.longValue() / (double)max.longValue());
        }
        if (res.get("stat.processcputime") != null) {
            res.put("used_cpu", MemberCollector.calcCPU(res, memberID, hqu));
        }
        res.put("uptime", (Long)res.get("uptime") / 1000L);
        res.put("nclients", ((Map)res.get("clients")).size());
        return res;
    }

    private static double calcCPU(Map metrics, String memberID, boolean hqu) {
        double cpu = 0.0;
        String cacheKey = (hqu ? "hqu_" : "") + memberID;
        long last_cpu = (Long)metrics.get("stat.processcputime") / 1000000L;
        long last_time = System.currentTimeMillis();
        CPUCacheEntry c_entry = (CPUCacheEntry)cpu_cache.get(cacheKey);
        if (c_entry != null) {
            long prev_cpu = c_entry.cpuTime;
            long prev_time = c_entry.time;
            int cpus = (Integer)metrics.get("stat.cpus");
            cpu = (double)(last_cpu - prev_cpu) / (double)((last_time - prev_time) * (long)cpus);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[calcCPU] cacheKey=" + cacheKey + " prev_cpu=" + prev_cpu + " last_cpu=" + last_cpu + " prev_time=" + prev_time + " last_time=" + last_time + " cpus=" + cpus));
                log.debug((Object)("[calcCPU] " + (last_cpu - prev_cpu) + "/" + (last_time - prev_time) * (long)cpus + " cpu=" + cpu));
            }
        } else {
            c_entry = new CPUCacheEntry();
        }
        c_entry.cpuTime = last_cpu;
        c_entry.time = last_time;
        cpu_cache.put(cacheKey, c_entry);
        return cpu;
    }

    private static class CPUCacheEntry {
        long cpuTime = 0L;
        long time = 0L;

        private CPUCacheEntry() {
        }
    }
}

