/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.spring;

import java.util.ArrayList;
import java.util.List;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.jmx.MxServerDetector;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public class SpringStandaloneApplicationDetector
extends MxServerDetector {
    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        List procs = this.getServerProcessList();
        for (int i = 0; i < procs.size(); ++i) {
            ConfigOption option;
            MxServerDetector.MxProcess process = (MxServerDetector.MxProcess)procs.get(i);
            String dir = process.getInstallPath();
            if (!this.isInstallTypeVersion(dir)) continue;
            ConfigResponse config = new ConfigResponse();
            ConfigSchema schema = this.getConfigSchema(this.getTypeInfo().getName(), 0);
            if (schema != null && (option = schema.getOption("process.query")) != null) {
                String query = "State.Name.sw=java,Args.*.eq=-D" + this.getProcHomeProperty() + "=" + dir;
                config.setValue(option.getName(), query);
            }
            if (process.getURL() != null) {
                config.setValue("jmx.url", process.getURL());
            } else {
                String[] args = process.getArgs();
                for (int j = 0; j < args.length && !this.configureMxURL(config, args[j]); ++j) {
                }
            }
            String fqn = platformConfig.getValue("platform.name") + " " + dir + " Spring Application";
            ServerResource server = new ServerResource();
            server.setType(this.getTypeInfo().getName());
            server.setInstallPath(dir);
            server.setName(fqn);
            server.setIdentifier(fqn);
            this.setProductConfig(server, config);
            server.setMeasurementConfig();
            servers.add(server);
        }
        return servers;
    }
}

