/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.appmgmt;

import com.springsource.hq.plugin.tcserver.plugin.appmgmt.FilePermissionsChanger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.PumpStreamHandler;

final class ChmodFilePermissionsChanger
implements FilePermissionsChanger {
    private final Log log = LogFactory.getLog(ChmodFilePermissionsChanger.class);
    private static final String EXECUTABLE_CHMOD = "chmod";
    private final String permissions;

    public ChmodFilePermissionsChanger(String permissions) {
        this.permissions = permissions;
    }

    public void changeFilePermissions(File file) throws PluginException {
        int returnCode;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Execute ex = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output));
        ex.setCommandline(new String[]{EXECUTABLE_CHMOD, this.permissions, file.getAbsolutePath()});
        this.log.info((Object)("Changing file permissions with command '" + ex.getCommandLineString() + "'"));
        try {
            returnCode = ex.execute();
        }
        catch (Exception e) {
            throw new PluginException("Failed to set permissions on war file", (Throwable)e);
        }
        if (returnCode != 0) {
            throw new PluginException("Failed to set permissions on war file: " + output.toString());
        }
    }
}

