/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.FileReadingSettingsFactory;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.FileSettingsRepository;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.ServerConfigManager;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.SettingsFactory;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.SettingsRepository;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.DefaultJvmOptionsConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.JvmOptionsConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.Settings;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.Environment;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.JvmOptions;
import com.thoughtworks.xstream.XStream;
import java.util.List;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServerConfigManager
implements ServerConfigManager {
    private final SettingsFactory settingsFactory = new FileReadingSettingsFactory();
    private final JvmOptionsConverter jvmOptionsConverter = new DefaultJvmOptionsConverter();
    private final XStream xstream = new XStream();
    private final SettingsRepository settingsRepository = new FileSettingsRepository();

    @Override
    public Settings getConfiguration(ConfigResponse config) throws PluginException {
        return this.settingsFactory.create(config);
    }

    @Override
    public void saveConfiguration(ConfigResponse config) throws PluginException {
        Settings settings;
        try {
            settings = (Settings)this.xstream.fromXML(config.getValue("SETTINGS"));
        }
        catch (Exception e) {
            throw new PluginException("Unable to read settings to save.  Cause: " + e.getMessage());
        }
        this.settingsRepository.saveConfiguration(config, settings);
    }

    @Override
    public void revertToPreviousConfiguration(ConfigResponse config) throws PluginException {
        this.settingsRepository.revertToPreviousConfiguration(config);
    }

    @Override
    public void putFile(ConfigResponse config) throws PluginException {
        this.settingsRepository.putFile(config);
    }

    @Override
    public void prepareFile(ConfigResponse config) throws PluginException {
        this.settingsRepository.prepareFile(config);
    }

    @Override
    public String getFile(ConfigResponse config) throws PluginException {
        return this.settingsFactory.getFile(config);
    }

    @Override
    public void copyFile(ConfigResponse config) throws PluginException {
        this.settingsRepository.copyFile(config);
    }

    @Override
    public boolean fileExists(ConfigResponse config) throws PluginException {
        return this.settingsRepository.fileExists(config);
    }

    @Override
    public void putJvmOpts(ConfigResponse config) throws PluginException {
        List strJvmOpts;
        try {
            strJvmOpts = (List)this.xstream.fromXML(config.getValue("JVM_OPTS"));
        }
        catch (Exception e) {
            throw new PluginException("Unable to read settings to save.  Cause: " + e.getMessage());
        }
        Environment environment = this.settingsFactory.createEnvironment(config);
        JvmOptions jvmOptions = this.jvmOptionsConverter.convert(strJvmOpts);
        environment.setJvmOptions(jvmOptions);
        this.settingsRepository.saveEnvironment(config, environment);
    }

    @Override
    public List<String> getJvmOpts(ConfigResponse config) throws PluginException {
        Environment environment = this.settingsFactory.createEnvironment(config);
        return this.jvmOptionsConverter.convert(environment.getJvmOptions());
    }
}

