/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.DefaultJvmOptionsConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.EnvironmentFactory;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.JvmOptionsConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixFileReadingEnvironmentFactory
implements EnvironmentFactory {
    private static final Log log = LogFactory.getLog(UnixFileReadingEnvironmentFactory.class);
    private JvmOptionsConverter jvmOptionsConverter = new DefaultJvmOptionsConverter();

    /*
     * Unable to fully structure code
     */
    @Override
    public Environment create(ConfigResponse config) throws PluginException {
        try {
            environment = new Environment();
            if (new File(String.valueOf(Metric.decode((String)config.getValue("installpath"))) + "/bin/setenv.sh").exists()) {
                envFile = String.valueOf(Metric.decode((String)config.getValue("installpath"))) + "/bin/setenv.sh";
                symbolTable = this.extractPropertyMapping(envFile);
                jvmOptsValues = new LinkedHashSet<String>();
                this.expandValue(symbolTable, "JVM_OPTS", jvmOptsValues);
                combJvmOptions = this.jvmOptionsConverter.convert(new ArrayList<String>(jvmOptsValues));
                environment.setJvmOptions(combJvmOptions);
                javaHome = new LinkedHashSet<String>();
                this.expandValue(symbolTable, "JAVA_HOME", javaHome);
                environment.setJavaHome(this.collectionToSpaceDelimitedString(javaHome));
            }
            return environment;
        }
        catch (IOException e2) {
            var6_12 = e2.getStackTrace();
            var5_10 = var6_12.length;
            var4_8 = 0;
            ** while (var4_8 < var5_10)
        }
lbl-1000:
        // 1 sources

        {
            elem = var6_12[var4_8];
            UnixFileReadingEnvironmentFactory.log.info((Object)elem.toString());
            ++var4_8;
            continue;
        }
lbl23:
        // 1 sources

        throw new PluginException("Unable to read existing tc Runtime configuration.  Cause: " + e2.getMessage());
        catch (Exception e) {
            UnixFileReadingEnvironmentFactory.log.error((Object)("Received " + e.getMessage()));
            e.printStackTrace();
            throw new PluginException("Unable to read existing tc Runtime configuration.  Cause: " + e.getMessage());
        }
    }

    protected String collectionToSpaceDelimitedString(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String entry : collection) {
            stringBuilder.append(entry).append(" ");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    protected Map<String, String[]> extractPropertyMapping(String envFile) throws IOException {
        HashMap<String, String[]> propertyMap = new HashMap<String, String[]>();
        BufferedReader envFileReader = new BufferedReader(new FileReader(envFile));
        try {
            String line;
            String multiLineKey = null;
            String multiLineValue = null;
            while ((line = envFileReader.readLine()) != null) {
                if (multiLineValue != null) {
                    if (line.contains("\\")) {
                        multiLineValue = String.valueOf(multiLineValue) + " " + line.replace("\\", "").trim();
                        continue;
                    }
                    multiLineValue = String.valueOf(multiLineValue) + " " + line.trim();
                    this.addEachValueToMap(propertyMap, multiLineKey, multiLineValue);
                    multiLineKey = null;
                    multiLineValue = null;
                    continue;
                }
                if (!line.contains("=")) continue;
                String key = line.substring(0, this.indexOfFirstEqualsSign(line));
                String value = line.substring(this.indexOfFirstEqualsSign(line) + 1);
                log.debug((Object)("Reading key/value pair " + key + "/" + value));
                if (!value.endsWith("\\")) {
                    this.addEachValueToMap(propertyMap, key, value);
                    continue;
                }
                multiLineKey = key;
                multiLineValue = String.valueOf(value.substring(0, value.length() - 1).trim()) + " ";
            }
            HashMap<String, String[]> hashMap = propertyMap;
            return hashMap;
        }
        finally {
            envFileReader.close();
        }
    }

    private int indexOfFirstEqualsSign(String line) {
        return line.indexOf("=");
    }

    private void addEachValueToMap(Map<String, String[]> propertyMap, String key, String value) {
        String[] splitValueBySpace;
        String strippedValue = this.stripOutsideQuotesAndTrim(value);
        String[] stringArray = splitValueBySpace = strippedValue.split("\\s+");
        int n = splitValueBySpace.length;
        int n2 = 0;
        while (n2 < n) {
            String splitValue = stringArray[n2];
            if (propertyMap.containsKey(key)) {
                this.appendNewValueToExistingEntry(propertyMap, key, splitValue);
            } else {
                propertyMap.put(key, new String[]{splitValue});
            }
            ++n2;
        }
    }

    protected String stripOutsideQuotesAndTrim(String value) {
        String trimmedValue = value.trim();
        if (trimmedValue.startsWith("\"") && trimmedValue.endsWith("\"")) {
            return trimmedValue.substring(1, trimmedValue.length() - 1).trim();
        }
        return trimmedValue;
    }

    private void appendNewValueToExistingEntry(Map<String, String[]> symbolTable, String key, String newValue) {
        String[] symbols = symbolTable.get(key);
        String[] newSymbols = Arrays.copyOf(symbols, symbols.length + 1);
        newSymbols[symbols.length] = newValue;
        symbolTable.put(key, newSymbols);
    }

    protected void expandValue(Map<String, String[]> propertyMap, String variable, Set<String> expandedValues) {
        if (propertyMap.containsKey(variable)) {
            String[] valuesForOurVariable;
            String[] stringArray = valuesForOurVariable = propertyMap.get(variable);
            int n = valuesForOurVariable.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!value.startsWith("$")) {
                    log.debug((Object)("About to unwrap last symbol '" + value + "'"));
                    expandedValues.add(this.stripOutsideQuotesAndTrim(value));
                } else {
                    String referencedVariable = value.replaceAll("[${}]", "");
                    this.expandValue(this.copyTableAndDrop(propertyMap, variable, value), referencedVariable, expandedValues);
                }
                ++n2;
            }
        }
    }

    private Map<String, String[]> copyTableAndDrop(Map<String, String[]> oldSymbolTable, String variable, String variableToRemove) {
        HashMap<String, String[]> newSymbolTable = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : oldSymbolTable.entrySet()) {
            if (entry.getKey().equals(variable)) {
                newSymbolTable.put(entry.getKey(), this.removeItemFromArray(entry.getValue(), variableToRemove));
                continue;
            }
            newSymbolTable.put(entry.getKey(), entry.getValue());
        }
        return newSymbolTable;
    }

    private String[] removeItemFromArray(String[] array, String valueToRemove) {
        ArrayList<String> newList = new ArrayList<String>();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!valueToRemove.equals(value)) {
                newList.add(value);
            }
            ++n2;
        }
        return newList.toArray(new String[0]);
    }
}

