/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.resources.jdbc;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AttributeNotFoundException;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.InvalidNodeException;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.resources.jdbc.DataSourceConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.resources.jdbc.DataSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourcesConverter
extends AbstractXmlElementConverter
implements XmlElementConverter<Set<DataSource>> {
    private static final String DATA_SOURCE_TYPE = "javax.sql.DataSource";
    private final DataSourceConverter dataSourceConverter = new DataSourceConverter();
    private final Log logger = LogFactory.getLog(DataSourcesConverter.class);
    private static final Set<DataSource> EMPTY_DATA_SOURCES = new HashSet<DataSource>(0, 1.0f);

    @Override
    public void convert(Document document, Element server, Set<DataSource> from, Properties catalinaProperties) {
        Element globalNamingResources;
        List<Element> globalNamingResourcesList = this.getChildElements(server, "GlobalNamingResources");
        if (globalNamingResourcesList.size() > 1) {
            throw new InvalidNodeException("Unable to determine existing DataSources.  Found multiple GlobalNamingResource Elements in server.xml");
        }
        HashSet<String> dataSourceIds = new HashSet<String>(from.size());
        for (DataSource dataSource : from) {
            dataSourceIds.add(dataSource.getId());
        }
        HashMap<String, Element> dataSourceElements = new HashMap<String, Element>();
        if (globalNamingResourcesList.isEmpty()) {
            globalNamingResources = document.createElement("GlobalNamingResources");
            server.appendChild(globalNamingResources);
        } else {
            globalNamingResources = globalNamingResourcesList.get(0);
            List<Element> resources = this.getChildElements(globalNamingResources, "Resource");
            int i = 0;
            while (i < resources.size()) {
                Element resource = resources.get(i);
                if (DATA_SOURCE_TYPE.equals(resource.getAttribute("type"))) {
                    String name = this.parseProperties(resource.getAttribute("name"), catalinaProperties);
                    if (dataSourceIds.contains(name)) {
                        dataSourceElements.put(name, resource);
                    } else if (this.dataSourceConverter.isDataSourceFactorySupported(resource, catalinaProperties)) {
                        globalNamingResources.removeChild(resource);
                    }
                }
                ++i;
            }
        }
        for (DataSource dataSource : from) {
            if (dataSourceElements.get(dataSource.getId()) == null) {
                Element dataSourceElement = document.createElement("Resource");
                dataSourceElement.setAttribute("type", DATA_SOURCE_TYPE);
                this.dataSourceConverter.convert(document, dataSourceElement, dataSource, catalinaProperties);
                globalNamingResources.appendChild(dataSourceElement);
                continue;
            }
            this.dataSourceConverter.convert(document, (Element)dataSourceElements.get(dataSource.getId()), dataSource, catalinaProperties);
        }
    }

    @Override
    public Set<DataSource> convert(Element server, Properties catalinaProperties) {
        List<Element> globalNamingResourcesList = this.getChildElements(server, "GlobalNamingResources");
        if (globalNamingResourcesList.size() == 0) {
            return EMPTY_DATA_SOURCES;
        }
        if (globalNamingResourcesList.size() > 1) {
            this.logger.warn((Object)"Unable to determine existing DataSources.  Found multiple GlobalNamingResource Elements in server.xml");
            return EMPTY_DATA_SOURCES;
        }
        Element globalNamingResources = globalNamingResourcesList.get(0);
        LinkedHashSet<DataSource> dataSources = new LinkedHashSet<DataSource>();
        List<Element> resources = this.getChildElements(globalNamingResources, "Resource");
        int i = 0;
        while (i < resources.size()) {
            Element resource = resources.get(i);
            if (DATA_SOURCE_TYPE.equals(resource.getAttribute("type"))) {
                try {
                    DataSource dataSource = this.dataSourceConverter.convert(resource, catalinaProperties);
                    if (dataSource != null) {
                        dataSources.add(dataSource);
                    }
                }
                catch (AttributeNotFoundException e) {
                    this.logger.warn((Object)("Error reading tc Runtime configuration.  Ignoring invalid Data Source found in server.xml.  Cause: " + e.getMessage()));
                }
            }
            ++i;
        }
        return dataSources;
    }
}

