/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.connector;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.connector.ConnectorConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.services.connector.AjpConnector;
import com.springsource.hq.plugin.tcserver.serverconfig.services.connector.Connector;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjpConnectorConverter
extends ConnectorConverter
implements XmlElementConverter<AjpConnector> {
    private static final String DEFAULT_PROTOCOL = "org.apache.coyote.ajp.AjpProtocol";
    private static final String PROTOCOL = "protocol";
    private static final String REQUEST_SECRET = "request.secret";
    private static final String REQUEST_USE_SECRET = "request.useSecret";

    @Override
    public AjpConnector convert(Element element, Properties catalinaProperties) {
        String protocol;
        String requestSecret;
        AjpConnector connector = new AjpConnector();
        this.convert((Connector)connector, element, catalinaProperties);
        String requestUseSecret = this.parseProperties(element.getAttribute(REQUEST_USE_SECRET), catalinaProperties);
        if (!"".equals(requestUseSecret)) {
            connector.setRequestUseSecret(Boolean.valueOf(requestUseSecret));
        }
        if (!"".equals(requestSecret = this.parseProperties(element.getAttribute(REQUEST_SECRET), catalinaProperties))) {
            connector.setRequestSecret(requestSecret);
        }
        if ("AJP/1.3".equals(protocol = this.parseProperties(element.getAttribute(PROTOCOL), catalinaProperties))) {
            connector.setProtocol(DEFAULT_PROTOCOL);
        } else {
            connector.setProtocol(protocol);
        }
        return connector;
    }

    @Override
    public void convert(Document document, Element connectorElement, AjpConnector from, Properties catalinaProperties) {
        super.convert(document, connectorElement, (Connector)from, catalinaProperties);
        this.setAttribute(connectorElement, REQUEST_SECRET, from.getRequestSecret(), catalinaProperties, false);
        this.setAttribute(connectorElement, REQUEST_USE_SECRET, from.getRequestUseSecret(), catalinaProperties, false);
        this.setAttribute(connectorElement, PROTOCOL, from.getProtocol(), catalinaProperties, true);
    }
}

