/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.OperatingSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatingSystemReflection {
    protected static Log log = LogFactory.getLog((String)"OperatingSystemReflection");
    private static final String CLASS_NAME = "org.hyperic.hq.product.HypericOperatingSystem";

    private static Class<?> getHypericOperatingSystemClass() {
        try {
            Class<?> hypericOperatingSystemClass = Class.forName(CLASS_NAME);
            log.debug((Object)"org.hyperic.hq.product.HypericOperatingSystem found!");
            return hypericOperatingSystemClass;
        }
        catch (ClassNotFoundException exception) {
            log.debug((Object)"org.hyperic.hq.product.HypericOperatingSystem not found!");
            return null;
        }
    }

    private static Object getStaticFieldValue(String fieldName) {
        try {
            Class<?> hypericOperatingSystemClass = OperatingSystemReflection.getHypericOperatingSystemClass();
            if (hypericOperatingSystemClass == null) {
                return null;
            }
            Field f1 = hypericOperatingSystemClass.getDeclaredField(fieldName);
            Object o = f1.get(null);
            return o;
        }
        catch (Exception e) {
            log.error((Object)("failed to get field=" + fieldName), (Throwable)e);
            return null;
        }
    }

    private static Object invokeStaticMethodWithParam(String methodName, String param) {
        try {
            Class<?> hypericOperatingSystemClass = OperatingSystemReflection.getHypericOperatingSystemClass();
            if (hypericOperatingSystemClass == null) {
                return null;
            }
            Method method = hypericOperatingSystemClass.getMethod(methodName, String.class);
            Object o = method.invoke(null, param);
            return o;
        }
        catch (Exception e) {
            log.error((Object)("invokeStaticMethodWithParam failed =" + methodName + " param=" + param), (Throwable)e);
            return null;
        }
    }

    private static Object invokeStaticMethod(String methodName, Class<?> hypericOperatingSystemClass) {
        try {
            Method method = hypericOperatingSystemClass.getMethod(methodName, new Class[0]);
            Object o = method.invoke(null, new Object[0]);
            return o;
        }
        catch (Exception e) {
            log.error((Object)("invokeStaticMethod failed =" + methodName), (Throwable)e);
            return null;
        }
    }

    private static Object getInstance(Class<?> hypericOperatingSystemClass) {
        return OperatingSystemReflection.invokeStaticMethod("getInstance", hypericOperatingSystemClass);
    }

    private static Object invokeObjectMethod(String methodName) {
        Class<?> hypericOperatingSystemClass = OperatingSystemReflection.getHypericOperatingSystemClass();
        if (hypericOperatingSystemClass == null) {
            return null;
        }
        Object o = OperatingSystemReflection.getInstance(hypericOperatingSystemClass);
        if (o == null) {
            return null;
        }
        try {
            Method method = hypericOperatingSystemClass.getMethod(methodName, new Class[0]);
            Object res = method.invoke(o, new Object[0]);
            return res;
        }
        catch (Exception e) {
            log.error((Object)("failed to invoke method=" + methodName));
            return null;
        }
    }

    public static String getName() {
        String name = (String)OperatingSystemReflection.invokeObjectMethod("getName");
        if (name == null) {
            return OperatingSystem.getInstance().getName();
        }
        return name;
    }

    public static String getDescription() {
        String res = (String)OperatingSystemReflection.invokeObjectMethod("getDescription");
        if (res == null) {
            res = OperatingSystem.getInstance().getDescription();
        }
        return res;
    }

    public static String getArch() {
        String res = (String)OperatingSystemReflection.invokeObjectMethod("getArch");
        if (res == null) {
            res = OperatingSystem.getInstance().getArch();
        }
        return res;
    }

    public static String getVersion() {
        String res = (String)OperatingSystemReflection.invokeObjectMethod("getVersion");
        if (res == null) {
            res = OperatingSystem.getInstance().getVersion();
        }
        return res;
    }

    public static String getVendor() {
        String res = (String)OperatingSystemReflection.invokeObjectMethod("getVendor");
        if (res == null) {
            res = OperatingSystem.getInstance().getVendor();
        }
        return res;
    }

    public static String getVendorVersion() {
        String res = (String)OperatingSystemReflection.invokeObjectMethod("getVendorVersion");
        if (res == null) {
            res = OperatingSystem.getInstance().getVendorVersion();
        }
        return res;
    }

    public static boolean isWin32(String osName) {
        Object res = OperatingSystemReflection.invokeStaticMethodWithParam("isWin32", osName);
        if (res == null) {
            return OperatingSystem.isWin32((String)osName);
        }
        return (Boolean)res;
    }

    public static boolean IS_WIN32() {
        Object o = OperatingSystemReflection.getStaticFieldValue("IS_WIN32");
        if (o == null) {
            return OperatingSystem.IS_WIN32;
        }
        return (Boolean)o;
    }

    public static boolean IS_HYPER_V() {
        Object o = OperatingSystemReflection.getStaticFieldValue("IS_HYPER_V");
        if (o == null) {
            return false;
        }
        return (Boolean)o;
    }
}

