/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.hyperic.hq.plugin.websphere.WebSphereProcess;
import org.hyperic.hq.plugin.websphere.WebsphereDetector;
import org.hyperic.hq.plugin.websphere.WebsphereProductPlugin;
import org.hyperic.hq.plugin.websphere.jmx.WebsphereRuntimeDiscoverer;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

public class WebsphereAdminDetector
extends WebsphereDetector {
    protected List discoverServers(ConfigResponse config) throws PluginException {
        if (!WebsphereProductPlugin.VALID_JVM) {
            return new ArrayList();
        }
        if (this.discoverer == null) {
            String version = this.getTypeInfo().getVersion();
            this.discoverer = new WebsphereRuntimeDiscoverer(version, this);
        }
        Properties props = this.getManager().getProperties();
        String[] credProps = new String[]{"username", "password", "server.node"};
        for (int i = 0; i < credProps.length; ++i) {
            String name = credProps[i];
            String value = props.getProperty(name, config.getValue(name));
            if (value == null) {
                value = "";
            }
            config.setValue(name, value);
        }
        return this.discoverer.discoverServers(config);
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList servers = new ArrayList();
        List processes = WebsphereAdminDetector.getServerProcessList(this.getProcessQuery());
        for (int i = 0; i < processes.size(); ++i) {
            List found;
            WebSphereProcess p = (WebSphereProcess)processes.get(i);
            if (!p.getServer().equals("nodeagent") || (found = this.getServerList(new File(p.getServerRoot()), null, p)) == null) continue;
            servers.addAll(found);
        }
        return servers;
    }
}

