/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.ConnectorException;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.TimeStatistic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.websphere.WebsphereStopWatch;
import org.hyperic.hq.plugin.websphere.WebsphereUtil;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.CollectorResult;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;

public abstract class WebsphereCollector
extends Collector {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ObjectName name;
    private String domain;

    protected final ObjectName getObjectName() {
        return this.name;
    }

    protected final void setObjectName(ObjectName name) {
        this.name = name;
    }

    protected final ObjectName newObjectNamePattern(String attrs) throws PluginException {
        try {
            return new ObjectName(this.domain + ":" + attrs + ",*");
        }
        catch (MalformedObjectNameException e) {
            throw new PluginException(e.getMessage());
        }
    }

    protected final String getServerAttributes() {
        return "J2EEServer=" + this.getServerName() + "," + "node=" + this.getNodeName();
    }

    protected final String getProcessAttributes() {
        return "process=" + this.getServerName() + "," + "node=" + this.getNodeName();
    }

    protected final void init() throws PluginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[init] (" + ((Object)((Object)this)).getClass().getSimpleName() + ") props=" + this.getProperties()));
        }
        AdminClient mServer = this.getMBeanServer();
        assert (mServer != null);
        if (mServer == null) {
            return;
        }
        try {
            this.domain = mServer.getDomainName();
        }
        catch (ConnectorException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        this.init(mServer);
        if (this.name != null) {
            this.setSource(this.name.toString());
        }
    }

    protected abstract void init(AdminClient var1) throws PluginException;

    private final String getNodeName() {
        return this.getProperties().getProperty("server.node");
    }

    protected final String getServerName() {
        return this.getProperties().getProperty("server.name");
    }

    protected final String getModuleName() {
        return this.getProperties().getProperty("Module");
    }

    private AdminClient getMBeanServer() {
        try {
            return WebsphereUtil.getMBeanServer(this.getProperties());
        }
        catch (MetricUnreachableException e) {
            this.setAvailability(false);
            this.setErrorMessage(e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    protected ObjectName resolve(AdminClient mServer, ObjectName name) throws PluginException {
        try {
            return WebsphereUtil.resolve(mServer, name);
        }
        catch (PluginException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    protected final Object getAttribute(AdminClient mServer, ObjectName name, String attr) throws PluginException {
        try {
            WebsphereStopWatch timer = new WebsphereStopWatch();
            Object o = mServer.getAttribute(name, attr);
            if (this.log.isDebugEnabled()) {
                String call = "getAttribute(" + name + ", " + attr + ")";
                if (o == null) {
                    this.log.debug((Object)(call + "==null"));
                }
                if (timer.isTooLong()) {
                    this.log.debug((Object)(call + " took: " + timer.getElapsedSeconds() + " seconds"));
                }
            }
            return o;
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getAttribute(" + name + ", " + attr + "): " + e.getMessage()), (Throwable)e);
            }
            throw new PluginException(e.getMessage());
        }
    }

    protected final Stats getStats(AdminClient mServer, ObjectName name) throws PluginException {
        Stats stats = (Stats)this.getAttribute(mServer, name, "stats");
        this.log.info((Object)("[getStats] name = " + name));
        for (int i = 0; i < stats.getStatistics().length; ++i) {
            Statistic statistic = stats.getStatistics()[i];
            this.log.info((Object)("[getStats] [" + this.getModuleName() + "] => statistic: " + statistic));
        }
        return stats;
    }

    private double getStatCount(Statistic stat) {
        if (stat instanceof CountStatistic) {
            return ((CountStatistic)stat).getCount();
        }
        if (stat instanceof RangeStatistic) {
            return ((RangeStatistic)stat).getCurrent();
        }
        if (stat instanceof TimeStatistic) {
            long count = ((TimeStatistic)stat).getCount();
            double value = count == 0L ? 0.0 : (double)(((TimeStatistic)stat).getTotalTime() / count);
            return value;
        }
        this.log.error((Object)("Unsupported stat type: " + stat.getName() + "/" + stat.getClass().getName()));
        return Double.NaN;
    }

    protected final double getStatCount(Stats stats, String metric) {
        Statistic stat = stats.getStatistic(metric);
        if (stat == null) {
            return Double.NaN;
        }
        return this.getStatCount(stat);
    }

    protected final void collectStatCount(Stats stats, String[][] attrs) {
        Stats[] _stats = new Stats[]{stats};
        this.collectStatCount(_stats, attrs);
    }

    protected final void collectStatCount(Stats[] stats, String[][] attrs) {
        for (int i = 0; i < attrs.length; ++i) {
            String[] entry = attrs[i];
            String statKey = entry[0];
            String pmiKey = entry.length == 1 ? statKey : entry[1];
            double val = 0.0;
            for (Stats stat : stats) {
                double _val = this.getStatCount(stat, statKey);
                if (_val == Double.NaN) continue;
                val += _val;
            }
            this.setValue(pmiKey, val);
        }
    }

    public final MetricValue getValue(Metric metric, CollectorResult result) {
        return super.getValue(metric, result);
    }

    protected final boolean collectStats(ObjectName name) throws PluginException {
        AdminClient mServer = this.getMBeanServer();
        if (mServer == null) {
            return false;
        }
        return this.collectStats(mServer, name);
    }

    private boolean collectStats(AdminClient mServer, ObjectName oname) throws PluginException {
        Stats stats = this.getStats(mServer, oname);
        if (stats == null) {
            this.setAvailability(false);
            return false;
        }
        this.setAvailability(true);
        String[] names = stats.getStatisticNames();
        Map values = this.getResult().getValues();
        for (int i = 0; i < names.length; ++i) {
            double val = this.getStatCount(stats, names[i]);
            String name = Character.toLowerCase(names[i].charAt(0)) + names[i].substring(1);
            values.put(name, new Double(val));
        }
        return true;
    }

    public final void collect() {
        AdminClient mServer;
        String serverName = this.getProperties().getProperty("server.name");
        String module = this.getProperties().getProperty("Module");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[collect] [" + serverName + "] name=" + this.getObjectName()));
            this.log.debug((Object)("[collect] [" + serverName + "] module=" + module));
            this.log.debug((Object)("[collect] [" + serverName + "] getProperties=" + this.getProperties()));
        }
        this.setAvailability(false);
        if (this.getObjectName() == null) {
            try {
                this.init();
            }
            catch (PluginException ex) {
                this.log.debug((Object)("[collect] [" + serverName + "] error!!! " + ex.getMessage()));
                return;
            }
        }
        if ((mServer = this.getMBeanServer()) == null) {
            return;
        }
        this.setAvailability(true);
        try {
            this.collect(mServer);
        }
        catch (PluginException e) {
            this.setAvailability(false);
            this.setMessage(e.getMessage());
            this.log.debug((Object)("[collect] [" + serverName + "] error:" + e.getMessage()), (Throwable)e);
        }
    }

    protected abstract void collect(AdminClient var1) throws PluginException;
}

