/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import com.ibm.websphere.pmi.PmiException;
import com.ibm.websphere.pmi.client.CpdCollection;
import com.ibm.websphere.pmi.client.CpdData;
import com.ibm.websphere.pmi.client.CpdLoad;
import com.ibm.websphere.pmi.client.CpdStat;
import com.ibm.websphere.pmi.client.CpdValue;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.client.PmiClient;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Properties;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;

public class WebspherePMI {
    private static HashMap clientCache = new HashMap();
    private static HashMap descriptorCache = new HashMap();

    public static PmiClient getPmiClient(Properties cfg) throws RemoteException {
        Properties props = WebspherePMI.getAdminProperties(cfg);
        return new PmiClientWrapper(props, "WAS50");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PmiClient getPmiClient(Metric metric) throws RemoteException {
        PmiClient pmiclient;
        String key = metric.getPropString();
        HashMap hashMap = clientCache;
        synchronized (hashMap) {
            pmiclient = (PmiClient)clientCache.get(key);
        }
        if (pmiclient == null) {
            pmiclient = WebspherePMI.getPmiClient(metric.getProperties());
            hashMap = clientCache;
            synchronized (hashMap) {
                clientCache.put(key, pmiclient);
            }
        }
        return pmiclient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PerfDescriptor getModuleDescriptor(PmiClient pmiclient, Metric metric) {
        PerfDescriptor moduleDescriptor;
        String key = metric.getObjectName();
        HashMap hashMap = descriptorCache;
        synchronized (hashMap) {
            moduleDescriptor = (PerfDescriptor)descriptorCache.get(key);
        }
        if (moduleDescriptor == null) {
            Properties props = metric.getObjectProperties();
            PerfDescriptor serverDescriptor = PmiClient.createPerfDescriptor((String)metric.getDomainName());
            moduleDescriptor = PmiClient.createPerfDescriptor((PerfDescriptor)serverDescriptor, (String)props.getProperty("Module"));
            HashMap hashMap2 = descriptorCache;
            synchronized (hashMap2) {
                descriptorCache.put(key, moduleDescriptor);
            }
        }
        return moduleDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        boolean haveStats;
        CpdCollection stats;
        PmiClientWrapper pmiclient;
        boolean isAvail = metric.isAvail();
        try {
            pmiclient = (PmiClientWrapper)WebspherePMI.getPmiClient(metric);
        }
        catch (RemoteException e) {
            if (isAvail) {
                return new Double(0.0);
            }
            Properties props = metric.getProperties();
            String msg = "Cannot connect to server " + props.getProperty("admin.host") + ":" + props.getProperty("admin.port");
            String rmsg = e.getMessage();
            if (rmsg.indexOf("\n") < 0) {
                msg = msg + " (" + rmsg + ")";
            }
            throw new MetricUnreachableException(msg, (Throwable)e);
        }
        PmiClientWrapper props = pmiclient;
        synchronized (props) {
            PerfDescriptor moduleDescriptor = WebspherePMI.getModuleDescriptor(pmiclient, metric);
            try {
                stats = pmiclient.get(metric, moduleDescriptor);
            }
            catch (PmiException pe) {
                String msg = "Error getting " + metric.getObjectName();
                throw new PluginException(msg, (Throwable)pe);
            }
        }
        boolean bl = haveStats = stats != null && stats.dataMembers() != null && stats.dataMembers().length > 0;
        if (isAvail) {
            if (haveStats) {
                return new Double(1.0);
            }
            return new Double(0.0);
        }
        CpdData data = null;
        if (haveStats) {
            data = WebspherePMI.findCpdData(stats.dataMembers(), metric.getAttributeName());
        }
        if (data == null) {
            String obj = metric.getObjectPropString();
            if (!obj.equals("Module=jvmRuntimeModule") && obj.startsWith("Module=") && obj.endsWith("Module")) {
                return new Double(Double.NaN);
            }
            throw new MetricNotFoundException(metric.getObjectName());
        }
        CpdValue value = data.getValue();
        switch (value.getType()) {
            case 4: {
                CpdStat cpdstat = (CpdStat)value;
                return new Double(cpdstat.getValue());
            }
            case 5: {
                CpdLoad cpdload = (CpdLoad)value;
                return new Double(cpdload.getValue());
            }
            case 1: 
            case 2: 
            case 3: {
                return new Double(value.getValue());
            }
        }
        throw new MetricInvalidException(metric.toString());
    }

    private static CpdData findCpdData(CpdData[] data, String name) {
        String match = "." + name;
        for (int i = 0; i < data.length; ++i) {
            if (!data[i].getDescriptor().getName().endsWith(match)) continue;
            return data[i];
        }
        return null;
    }

    public static Properties getAdminProperties(Properties cfg) {
        String host = cfg.getProperty("admin.host", "localhost");
        String port = cfg.getProperty("admin.port", "8880");
        Properties props = new Properties();
        props.setProperty("type", "SOAP");
        props.setProperty("host", host);
        props.setProperty("port", port);
        String user = cfg.getProperty("username", "");
        String pass = cfg.getProperty("password", "");
        if (!"".equals(user) && !"".equals(pass)) {
            props.setProperty("username", user);
            props.setProperty("password", pass);
            props.setProperty("securityEnabled", "true");
        }
        return props;
    }

    static class PmiClientWrapper
    extends PmiClient {
        HashMap cache = new HashMap();

        public PmiClientWrapper() throws RemoteException {
        }

        public PmiClientWrapper(String arg0, String arg1, String arg2) throws RemoteException {
            super(arg0, arg1, arg2);
        }

        public PmiClientWrapper(Properties arg0, String arg1) throws RemoteException {
            super(arg0, arg1);
        }

        public CpdCollection get(Metric metric, PerfDescriptor desc) throws PmiException {
            long timeNow = System.currentTimeMillis();
            String key = metric.getObjectName();
            CpdCache cacheValue = (CpdCache)this.cache.get(key);
            if (cacheValue == null) {
                cacheValue = new CpdCache();
                this.cache.put(key, cacheValue);
            } else if (timeNow - cacheValue.timestamp > (long)cacheValue.expire) {
                cacheValue.value = null;
            }
            if (cacheValue.value == null) {
                cacheValue.timestamp = timeNow;
                cacheValue.value = super.get(desc, false);
            }
            return cacheValue.value;
        }
    }

    static class CpdCache {
        int expire = 600000;
        long timestamp = 0L;
        CpdCollection value = null;

        CpdCache() {
        }
    }
}

