/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere.jmx;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;

public class DumpMBeans {
    public static void main(String[] args) throws Exception {
        boolean statsOnly = false;
        String host = System.getProperty("admin.host", "localhost");
        String port = System.getProperty("admin.port", "8880");
        String user = System.getProperty("username");
        String pass = System.getProperty("password");
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-stats")) continue;
            statsOnly = true;
        }
        Properties props = new Properties();
        props.setProperty("type", "SOAP");
        props.setProperty("host", host);
        props.setProperty("port", port);
        if (user != null && pass != null) {
            props.setProperty("username", user);
            props.setProperty("password", pass);
            props.setProperty("securityEnabled", "true");
        }
        AdminClient mServer = null;
        try {
            mServer = AdminClientFactory.createAdminClient((Properties)props);
        }
        catch (ConnectorException e) {
            System.out.println("Exception creating admin client: " + (Object)((Object)e));
            e.printStackTrace();
        }
        for (ObjectName obj : mServer.queryNames(null, null)) {
            MBeanInfo info = mServer.getMBeanInfo(obj);
            System.out.println("");
            System.out.println("MBean: " + info.getClassName());
            System.out.println("Name:  " + obj);
            if (statsOnly) {
                try {
                    Object stats = mServer.getAttribute(obj, "stats");
                    System.out.println("Stats-Class: " + stats.getClass().getName());
                    System.out.println("Stats: " + stats);
                }
                catch (AttributeNotFoundException e) {
                    System.out.println("Stats: NONE");
                }
                catch (Exception e) {
                    System.out.println("Stats: " + e);
                }
                continue;
            }
            MBeanAttributeInfo[] attrs = info.getAttributes();
            for (int k = 0; k < attrs.length; ++k) {
                String name = attrs[k].getName();
                String value = "null";
                try {
                    Object o = mServer.getAttribute(obj, name);
                    if (o != null) {
                        value = o.getClass().isArray() ? Arrays.asList((Object[])o).toString() : o.toString();
                    }
                }
                catch (Exception e) {
                    value = e.getMessage();
                }
                System.out.println("\t" + k + ". Attribute: " + name + " = " + value);
            }
            MBeanOperationInfo[] ops = info.getOperations();
            for (int i = 0; i < ops.length; ++i) {
                ArrayList<String> sig = new ArrayList<String>();
                MBeanParameterInfo[] params = ops[i].getSignature();
                for (int j = 0; j < params.length; ++j) {
                    sig.add(params[j].getType());
                }
                System.out.println("\t Operation: " + ops[i].getReturnType() + " " + ops[i].getName() + " " + sig);
            }
        }
    }
}

