/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere.jmx;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.ConnectorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.websphere.WebSphereProcess;
import org.hyperic.hq.plugin.websphere.WebsphereDetector;
import org.hyperic.hq.plugin.websphere.WebsphereUtil;
import org.hyperic.hq.plugin.websphere.jmx.AppServerQuery;
import org.hyperic.hq.plugin.websphere.jmx.ApplicationQuery;
import org.hyperic.hq.plugin.websphere.jmx.EJBModuleQuery;
import org.hyperic.hq.plugin.websphere.jmx.JDBCProviderQuery;
import org.hyperic.hq.plugin.websphere.jmx.NodeQuery;
import org.hyperic.hq.plugin.websphere.jmx.ThreadPoolQuery;
import org.hyperic.hq.plugin.websphere.jmx.WebModuleQuery;
import org.hyperic.hq.plugin.websphere.jmx.WebSphereQuery;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginUpdater;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.hq.product.jmx.ServiceTypeFactory;
import org.hyperic.util.config.ConfigResponse;

public class WebsphereRuntimeDiscoverer {
    private Log log = LogFactory.getLog((String)WebsphereRuntimeDiscoverer.class.getName());
    private ServiceTypeFactory serviceTypeFactory = new ServiceTypeFactory();
    private String version;
    private WebsphereDetector serverDetector;
    static final WebSphereQuery[] serviceQueries = new WebSphereQuery[]{new JDBCProviderQuery(), new ThreadPoolQuery(), new ApplicationQuery()};
    static final WebSphereQuery[] moduleQueries = new WebSphereQuery[]{new EJBModuleQuery(), new WebModuleQuery()};
    private PluginUpdater pluginUpdater = new PluginUpdater();

    public WebsphereRuntimeDiscoverer(String version, WebsphereDetector serverDetector) {
        this.version = version;
        this.serverDetector = serverDetector;
    }

    private List discover(AdminClient mServer, String domain, WebSphereQuery query) throws PluginException {
        Set beans;
        ObjectName scope;
        ArrayList<WebSphereQuery> res = new ArrayList<WebSphereQuery>();
        boolean isApp = query instanceof ApplicationQuery;
        try {
            scope = new ObjectName(domain + ":" + query.getScope() + ",*");
        }
        catch (MalformedObjectNameException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        try {
            query.setMBeanServer(mServer);
            beans = mServer.queryNames(scope, null);
        }
        catch (ConnectorException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        for (ObjectName obj : beans) {
            if (!query.apply(obj)) continue;
            WebSphereQuery type = query.cloneInstance();
            type.setName(obj.getKeyProperty("name"));
            type.setObjectName(obj);
            type.getAttributes(mServer, obj);
            res.add(type);
            if (!isApp) continue;
            for (int i = 0; i < moduleQueries.length; ++i) {
                WebSphereQuery moduleQuery = moduleQueries[i];
                moduleQuery.setParent(type);
                res.addAll(this.discover(mServer, domain, moduleQuery));
            }
        }
        return res;
    }

    public List discoverServices(ConfigResponse config) throws PluginException {
        List res;
        block4: {
            this.log.debug((Object)("[discoverServices] config=" + config));
            res = new ArrayList();
            try {
                AdminClient mServer = WebsphereUtil.getMBeanServer(config.toProperties());
                String domain = mServer.getDomainName();
                WebSphereProcess proc = new WebSphereProcess(config);
                NodeQuery nodeQuery = new NodeQuery();
                nodeQuery.setName(proc.getNode());
                nodeQuery.setCell(proc.getCell());
                nodeQuery.setVersion(this.version);
                AppServerQuery serverQuery = new AppServerQuery();
                serverQuery.setParent(nodeQuery);
                serverQuery.installpath = proc.getServerRoot();
                List servers = this.discover(mServer, domain, serverQuery);
                for (int i = 0; i < servers.size(); ++i) {
                    WebSphereQuery server = (WebSphereQuery)servers.get(i);
                    if (!server.getName().equals(proc.getServer())) continue;
                    res = this.discoverServices(mServer, server, proc);
                }
            }
            catch (MetricUnreachableException e) {
                throw new PluginException(e.getMessage(), (Throwable)e);
            }
            catch (ConnectorException e) {
                if (!this.log.isDebugEnabled()) break block4;
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return res;
    }

    private List discoverServices(AdminClient mServer, WebSphereQuery server, WebSphereProcess proc) throws ConnectorException, PluginException {
        ConfigResponse controlConfig = new ConfigResponse();
        String profile = proc.getServerRoot().substring(proc.getServerRoot().lastIndexOf("/") + 1);
        String domain = mServer.getDomainName();
        ArrayList<ServiceResource> res = new ArrayList<ServiceResource>();
        ArrayList services = new ArrayList();
        for (int j = 0; j < serviceQueries.length; ++j) {
            WebSphereQuery serviceQuery = serviceQueries[j];
            serviceQuery.setParent(server);
            services.addAll(this.discover(mServer, domain, serviceQuery));
        }
        for (int k = 0; k < services.size(); ++k) {
            WebSphereQuery service = (WebSphereQuery)services.get(k);
            ServiceResource aiservice = new ServiceResource();
            String svcType = service.getResourceName();
            aiservice.setType(svcType);
            aiservice.setName(svcType + " " + profile + " " + proc.getCell() + " " + service.getFullName());
            this.log.debug((Object)("discovered service: " + aiservice.getName()));
            ConfigResponse productConfig = new ConfigResponse((Map)service.getProperties());
            productConfig.setValue("server.name", proc.getServer());
            ConfigResponse metricConfig = new ConfigResponse((Map)service.getMetricProperties());
            aiservice.setProductConfig(productConfig);
            aiservice.setMeasurementConfig(metricConfig);
            if (service.hasControl()) {
                aiservice.setControlConfig(controlConfig);
            }
            ConfigResponse cprops = new ConfigResponse((Map)service.getCustomProperties());
            aiservice.setCustomProperties(cprops);
            res.add(aiservice);
        }
        return res;
    }

    private boolean hasValidCredentials(AdminClient mServer, String domain, String node, String server) {
        String name = domain + ":" + "process=" + server + "," + "node=" + node + "," + "type=Perf,name=PerfMBean,*";
        String method = "getInstrumentationLevelString";
        try {
            Object level = WebsphereUtil.invoke(mServer, name, "getInstrumentationLevelString", new Object[0], new String[0]);
            this.log.debug((Object)(name + ": level=" + level));
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to determine PMI level for '" + name + "': " + e.getMessage()));
            return false;
        }
    }

    public List discoverServers(ConfigResponse config) throws PluginException {
        String domain;
        AdminClient mServer;
        ArrayList<ServerResource> aiservers = new ArrayList<ServerResource>();
        WebSphereProcess parentProc = new WebSphereProcess(config);
        this.log.debug((Object)("discover using: " + config));
        try {
            mServer = WebsphereUtil.getMBeanServer(config.toProperties());
            domain = mServer.getDomainName();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            return aiservers;
        }
        String installpath = config.getValue("installpath");
        String node = config.getValue("server.node");
        NodeQuery nodeQuery = new NodeQuery();
        nodeQuery.setName(node);
        nodeQuery.setVersion(this.version);
        AppServerQuery serverQuery = new AppServerQuery();
        serverQuery.setParent(nodeQuery);
        serverQuery.installpath = installpath;
        List servers = this.discover(mServer, domain, serverQuery);
        if (servers.size() == 0) {
            this.log.warn((Object)("No servers discovered for node: " + node));
        }
        for (int i = 0; i < servers.size(); ++i) {
            List res;
            serverQuery = (AppServerQuery)servers.get(i);
            String srvName = serverQuery.getName();
            ConfigResponse productConfig = new ConfigResponse((Map)serverQuery.getProperties());
            WebSphereProcess proc = new WebSphereProcess(config);
            proc.setServer(srvName);
            this.log.debug((Object)("[discoverServers] --> config=" + config));
            this.log.debug((Object)("[discoverServers] --> proc=" + proc));
            productConfig.merge(config, false);
            productConfig.setValue("server.name", serverQuery.getName());
            productConfig.setValue("admin.host", this.serverDetector.getAdminHost(proc));
            productConfig.setValue("admin.port", this.serverDetector.getAdminPort(proc));
            this.log.debug((Object)("[discoverServers] --> pc=" + productConfig));
            ServerResource server = new ServerResource();
            aiservers.add(server);
            server.setInstallPath(installpath);
            server.setIdentifier(proc.getIdentifier());
            String srvType = serverQuery.getResourceName();
            if (serverQuery.getName().equals(parentProc.getServer())) {
                srvType = "WebSphere Admin " + serverQuery.getVersion();
            }
            server.setType(srvType);
            server.setName(WebsphereDetector.getPlatformName() + " " + srvType + " " + proc.getServerName());
            this.log.debug((Object)("discovered server: " + server.getName()));
            server.setProductConfig(productConfig);
            server.setMeasurementConfig(new ConfigResponse((Map)serverQuery.getMetricProperties()));
            server.setControlConfig(this.serverDetector.getControlConfig(proc));
            server.setCustomProperties(new ConfigResponse((Map)serverQuery.getCustomProperties()));
            ArrayList services = new ArrayList();
            if (!this.hasValidCredentials(mServer, domain, node, srvName)) continue;
            try {
                res = this.discoverServices(mServer, serverQuery, proc);
            }
            catch (ConnectorException e) {
                throw new PluginException(e.getMessage(), (Throwable)e);
            }
            for (int n = 0; n < res.size(); ++n) {
                server.addService((ServiceResource)res.get(n));
            }
        }
        return aiservers;
    }
}

