/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.ProcCred;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public final class Utils {
    public static final String SERVER_RESOURCE_CONFIG_PROCESS_USERNAME = "process.username";
    public static final String SERVER_RESOURCE_CONFIG_PROCESS_GROUP = "process.group";
    private static final String USER_NAME_ROOT = "root";
    private static volatile String agentUser;
    private static final Log LOGGER;

    static {
        LOGGER = LogFactory.getLog(Utils.class);
    }

    private Utils() {
    }

    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static boolean isRoot(String username) {
        return USER_NAME_ROOT.equals(username);
    }

    public static String getAgentUser() throws PluginException {
        String localAgentUser;
        block9: {
            localAgentUser = agentUser;
            if (localAgentUser == null) {
                Sigar sigar = new Sigar();
                long pid = sigar.getPid();
                try {
                    try {
                        localAgentUser = sigar.getProcCredName(pid).getUser();
                    }
                    catch (SigarException se) {
                        LOGGER.warn((Object)("Failed to get the name of the user running the agent process with pid: " + pid));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)se);
                        }
                        try {
                            ProcCred procCred = sigar.getProcCred(pid);
                            localAgentUser = String.valueOf(procCred.getUid());
                        }
                        catch (SigarException sigarException) {
                            LOGGER.warn((Object)("Failed to get the id of the user running the agent process with pid: " + pid));
                        }
                        LOGGER.info((Object)("Using " + localAgentUser + " as the user for agent process with pid: " + pid));
                        sigar.close();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.info((Object)("Using " + localAgentUser + " as the user for agent process with pid: " + pid));
                    sigar.close();
                    throw throwable;
                }
                LOGGER.info((Object)("Using " + localAgentUser + " as the user for agent process with pid: " + pid));
                sigar.close();
            }
        }
        agentUser = localAgentUser;
        return localAgentUser;
    }
}

