/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.appmgmt;

import com.springsource.hq.plugin.tcserver.plugin.appmgmt.ApplicationManager;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.FileOwnershipChanger;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.FilePermissionsChanger;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.ObjectNameUtils;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.domain.Application;
import com.springsource.hq.plugin.tcserver.plugin.wrapper.JmxUtils;
import com.springsource.hq.plugin.tcserver.util.application.ApplicationIdentifier;
import com.springsource.hq.plugin.tcserver.util.application.ApplicationUtils;
import com.springsource.hq.plugin.tcserver.util.tomcat.TomcatNameUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.common.ApplicationException;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TomcatJmxApplicationManager
implements ApplicationManager {
    private static final String OVERALL_STATUS_RUNNING = "Running";
    private static final String OVERALL_STATUS_STOPPED = "Stopped";
    private static final String APPLICATION = "APPLICATION";
    private static final String DEPLOY_PATH = "DEPLOY_PATH";
    private static final String HOST_NAME = "HOST_NAME";
    private static final String SERVICE_NAME = "SERVICE_NAME";
    private static final String WAR_FILE_LOCATION = "WAR_FILE_LOCATION";
    private static final String MULTI_REVISION_CAPABLE = "MULTI_REVISION_CAPABLE";
    private static final String INSTANCE_USERNAME = "process.username";
    private static final String INSTANCE_GROUP = "process.group";
    private final Log LOGGER = LogFactory.getLog(TomcatJmxApplicationManager.class);
    private final JmxUtils mxUtil;
    private final FilePermissionsChanger filePermissionsChanger;
    private final FileOwnershipChanger fileOwnershipChanger;

    public TomcatJmxApplicationManager(JmxUtils jmxUtils, FilePermissionsChanger filePermissionsChanger, FileOwnershipChanger fileOwnershipChanger) {
        this.mxUtil = jmxUtils;
        this.filePermissionsChanger = filePermissionsChanger;
        this.fileOwnershipChanger = fileOwnershipChanger;
    }

    private boolean checkFileExists(String fileLocation) {
        boolean exists = false;
        try {
            exists = new File(fileLocation).isFile();
        }
        catch (Exception e) {
            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return exists;
    }

    private Set<Application> createApplicationStatusMapping(Properties configProperties, String serviceName, String hostName, boolean tomcat7) throws PluginException {
        SortedSet<Application> applications = this.fetchApplications(configProperties, serviceName, hostName);
        Iterator applicationsIterator = applications.iterator();
        while (applicationsIterator.hasNext()) {
            Application application = (Application)applicationsIterator.next();
            try {
                this.fetchAndApplyApplicationStatus(configProperties, serviceName, hostName, application);
                this.fetchAndApplySessionCount(configProperties, hostName, application, tomcat7);
            }
            catch (PluginException pe) {
                this.LOGGER.warn((Object)String.format("Failed to collect details for application '%s' deployed on service '%s' and host '%s'", application.getName(), serviceName, hostName), (Throwable)pe);
                applicationsIterator.remove();
            }
        }
        return applications;
    }

    private void fetchAndApplySessionCount(Properties configProperties, String hostName, Application application, boolean tomcat7) throws PluginException {
        Integer sessionCount = 0;
        String appObjectName = ObjectNameUtils.getManagerMBeanObjectNameForApplication(hostName, application, tomcat7);
        try {
            MBeanServerConnection mbsc = this.mxUtil.getMBeanServer(configProperties);
            boolean mbeanIsRegistered = mbsc.isRegistered(new ObjectName(appObjectName));
            if (mbeanIsRegistered) {
                sessionCount = (Integer)this.mxUtil.getValue(configProperties, appObjectName, "activeSessions");
            }
            application.setSessionCount(sessionCount.intValue());
        }
        catch (PluginException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw this.createPluginException(e);
        }
    }

    private void fetchAndApplyApplicationStatus(Properties configProperties, String serviceName, String hostName, Application application) throws PluginException {
        String status = this.fetchApplicationStatus(configProperties, serviceName, hostName, application.getName(), application.getVersion());
        application.setStatus(status);
    }

    private String fetchApplicationStatus(Properties configProperties, String serviceName, String hostName, String applicationName, int applicationVersion) throws PluginException {
        Object[] arguments;
        String[] types;
        String applicationPath = TomcatNameUtils.convertNameToPath((String)applicationName);
        String objectName = this.getObjectName();
        if (this.isTcRuntime250OrLater(objectName, "getApplicationState", 4, configProperties)) {
            types = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};
            arguments = new Object[]{serviceName, hostName, applicationPath, ApplicationUtils.convertVersionToPaddedString((int)applicationVersion)};
        } else {
            types = new String[]{String.class.getName(), String.class.getName(), String.class.getName()};
            arguments = new Object[]{serviceName, hostName, applicationPath};
        }
        try {
            String status = (String)this.mxUtil.invoke(configProperties, objectName, "getApplicationState", arguments, types);
            return this.convertDetailedStatusToOverallStatus(status);
        }
        catch (PluginException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw this.createPluginException(e);
        }
    }

    private SortedSet<Application> fetchApplications(Properties configProperties, String serviceName, String hostName) throws PluginException {
        try {
            Object applicationsObj = this.mxUtil.invoke(configProperties, this.getObjectName(), "listApplications", new Object[]{serviceName, hostName}, new String[]{String.class.getName(), String.class.getName()});
            return this.extractApplications(applicationsObj);
        }
        catch (PluginException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw this.createPluginException(e);
        }
    }

    private SortedSet<Application> extractApplications(Object applicationsObject) {
        TreeSet<Application> applications = new TreeSet<Application>();
        if (this.isTcRuntime25OrLater(applicationsObject)) {
            Set applicationsSet = (Set)applicationsObject;
            for (Map item : applicationsSet) {
                Application application = new Application();
                application.setName(TomcatNameUtils.convertPathToName((String)((String)item.get("path"))));
                String versionString = (String)item.get("version");
                if (versionString.length() > 0) {
                    application.setVersion(Integer.parseInt(versionString));
                } else {
                    application.setVersion(0);
                }
                applications.add(application);
            }
        } else {
            String[] stringArray = (String[])applicationsObject;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String applicationPath = stringArray[n2];
                Application application = new Application();
                application.setName(TomcatNameUtils.convertPathToName((String)applicationPath));
                application.setVersion(0);
                applications.add(application);
                ++n2;
            }
        }
        return applications;
    }

    private boolean isTcRuntime25OrLater(Object applicationsObj) {
        return applicationsObj instanceof Set;
    }

    private PluginException createPluginException(Throwable throwable) {
        PluginException pluginException;
        if (throwable instanceof JMRuntimeException) {
            Throwable cause = throwable.getCause();
            pluginException = new PluginException(cause.getMessage(), cause);
        } else {
            pluginException = new PluginException(throwable.getMessage(), throwable);
        }
        return pluginException;
    }

    @Override
    public void removeTemporaryWarFile(ConfigResponse config) {
        try {
            File file = new File(config.getValue("fileName"));
            file.delete();
        }
        catch (Exception e) {
            this.LOGGER.debug((Object)("Deleting temporary file failed: " + e.getMessage()));
        }
    }

    @Override
    public Object deploy(ConfigResponse config) throws PluginException {
        Map<String, String> connectionInformation = this.getConnectionInformation(config);
        String deployPathString = config.getValue(DEPLOY_PATH);
        String warFileLocation = config.getValue(WAR_FILE_LOCATION);
        this.LOGGER.debug((Object)("deploypath - " + deployPathString + "  war -  " + warFileLocation));
        String resultMessage = null;
        String deployPath = TomcatNameUtils.convertNameToPath((String)deployPathString);
        boolean fileExists = this.checkFileExists(warFileLocation);
        if (fileExists) {
            File warFile = new File(warFileLocation);
            this.filePermissionsChanger.changeFilePermissions(warFile);
            this.fileOwnershipChanger.changeFileOwnership(warFile, config.getValue(INSTANCE_USERNAME), config.getValue(INSTANCE_GROUP));
            resultMessage = this.doDeploy(config, connectionInformation, warFileLocation, resultMessage, deployPath);
        } else {
            resultMessage = "Failure - Application " + deployPathString + " failed to deploy - No file exists at location: " + warFileLocation;
        }
        return resultMessage;
    }

    private String doDeploy(ConfigResponse config, Map<String, String> connectionInformation, String warFileLocation, String resultMessage, String deployPath) throws PluginException {
        Object[] arguments;
        String[] types;
        String tempDeployPath = deployPath;
        if (deployPath.indexOf("##") > 0) {
            tempDeployPath = deployPath.substring(0, deployPath.indexOf("##"));
        }
        this.LOGGER.debug((Object)("About to deploy " + config));
        String objectName = this.getObjectName();
        String serviceName = connectionInformation.get(SERVICE_NAME);
        String hostName = connectionInformation.get(HOST_NAME);
        String newRevision = this.getNewRevisionForApplication(config, tempDeployPath, serviceName, hostName);
        if (newRevision != null) {
            types = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};
            arguments = new Object[]{serviceName, hostName, tempDeployPath, newRevision, warFileLocation};
        } else {
            types = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};
            arguments = new Object[]{serviceName, hostName, tempDeployPath, warFileLocation};
        }
        try {
            this.mxUtil.invoke(config.toProperties(), objectName, "deployApplication", arguments, types);
            resultMessage = "Ok - Application " + tempDeployPath + " has deployed.";
        }
        catch (ApplicationException e) {
            this.LOGGER.debug((Object)("ApplicationException = " + (Object)((Object)e)));
            throw this.createPluginException(e);
        }
        catch (RuntimeException e) {
            this.LOGGER.debug((Object)("RuntimeException = " + e));
            this.LOGGER.debug((Object)e.getLocalizedMessage());
            resultMessage = "Failure - " + this.createPluginException(e).getMessage();
        }
        this.LOGGER.debug((Object)("Results = " + resultMessage));
        return resultMessage;
    }

    private String getNewRevisionForApplication(ConfigResponse config, String deployPath, String serviceName, String hostName) throws PluginException {
        String newRevision = null;
        if (Boolean.valueOf(config.getValue(MULTI_REVISION_CAPABLE)).booleanValue()) {
            try {
                SortedSet<Application> applications = this.fetchApplications(config.toProperties(), serviceName, hostName);
                newRevision = ApplicationUtils.getNewRevisionForApplication(applications, (String)deployPath);
            }
            catch (Exception e) {
                throw this.createPluginException(e);
            }
        }
        return newRevision;
    }

    private List<ApplicationIdentifier> getApplicationIdentifiers(ConfigResponse config) {
        Set keys = config.getKeys();
        ArrayList<ApplicationIdentifier> applicationIdentifiers = new ArrayList<ApplicationIdentifier>();
        int i = 0;
        while (i < keys.size()) {
            if (keys.contains(APPLICATION + i)) {
                String applicationIdentifierString = config.getValue(APPLICATION + i);
                applicationIdentifiers.add(new ApplicationIdentifier(applicationIdentifierString));
            }
            ++i;
        }
        return applicationIdentifiers;
    }

    private Map<String, String> getConnectionInformation(ConfigResponse config) throws PluginException {
        LinkedHashMap<String, String> connectionInformation = new LinkedHashMap<String, String>();
        if (this.mxUtil.checkConnection(config)) {
            String serviceName = config.getValue(SERVICE_NAME, "Catalina");
            connectionInformation.put(SERVICE_NAME, serviceName);
            String hostName = config.getValue(HOST_NAME, "localhost");
            connectionInformation.put(HOST_NAME, hostName);
            this.LOGGER.debug((Object)("ConnectionInfo: SERVICE_NAME = " + serviceName + ", HOST_NAME = " + hostName));
            boolean canExecute = false;
            try {
                String[] services = (String[])this.mxUtil.invoke(config.toProperties(), this.getObjectName(), "getServices", new Object[0], new String[0]);
                if (Arrays.asList(services).contains(serviceName) && Arrays.asList((String[])this.mxUtil.invoke(config.toProperties(), this.getObjectName(), "getHosts", new Object[]{serviceName}, new String[]{String.class.getName()})).contains(hostName)) {
                    canExecute = true;
                }
            }
            catch (ApplicationException e) {
                throw this.createPluginException(e);
            }
            if (!canExecute) {
                throw new PluginException("The service name (" + serviceName + ") and host name (" + hostName + ") does not match any services on this resource. " + "The resource server configuration may be out of sync with the other group members.");
            }
        } else {
            throw new PluginException("Unable to connect to the instance. Please verify the instance is running and whether the JMX configuration is correct.");
        }
        return connectionInformation;
    }

    protected String getObjectName() {
        return "tcServer:type=Serviceability,name=Deployer";
    }

    private String convertDetailedStatusToOverallStatus(String detailedStatus) {
        String overallStatus = OVERALL_STATUS_STOPPED;
        this.LOGGER.debug((Object)("DETAILED STATUS = " + detailedStatus));
        if (detailedStatus.equals("AVAILABLE") || detailedStatus.equals("STARTED")) {
            overallStatus = OVERALL_STATUS_RUNNING;
        }
        return overallStatus;
    }

    private boolean isApplicationStopped(ApplicationIdentifier applicationIdentifier, String service, String host, Properties configProperties) throws PluginException {
        return OVERALL_STATUS_STOPPED.equals(this.fetchApplicationStatus(configProperties, service, host, applicationIdentifier.getName(), applicationIdentifier.getVersion()));
    }

    private boolean isApplicationRunning(ApplicationIdentifier applicationIdentifier, String service, String host, Properties configProperties) throws PluginException {
        return OVERALL_STATUS_RUNNING.equals(this.fetchApplicationStatus(configProperties, service, host, applicationIdentifier.getName(), applicationIdentifier.getVersion()));
    }

    @Override
    public Map<String, List<String>> getServiceHostMappings(ConfigResponse config) throws PluginException {
        LinkedHashMap<String, List<String>> serviceHostMapping = new LinkedHashMap<String, List<String>>();
        if (this.mxUtil.checkConnection(config)) {
            try {
                String[] services;
                String[] stringArray = services = (String[])this.mxUtil.invoke(config.toProperties(), this.getObjectName(), "getServices", new Object[0], new String[0]);
                int n = services.length;
                int n2 = 0;
                while (n2 < n) {
                    String service = stringArray[n2];
                    String[] hosts = (String[])this.mxUtil.invoke(config.toProperties(), this.getObjectName(), "getHosts", new Object[]{service}, new String[]{String.class.getName()});
                    serviceHostMapping.put(service, Arrays.asList(hosts));
                    ++n2;
                }
            }
            catch (ApplicationException e) {
                throw this.createPluginException(e);
            }
        } else {
            throw new PluginException("Unable to connect to the instance. Please verify the instance is running and whether the JMX configuration is correct.");
        }
        return serviceHostMapping;
    }

    @Override
    public Set<Application> list(ConfigResponse config) throws PluginException {
        this.LOGGER.debug((Object)("CONFIG = " + config.toString()));
        Map<String, String> connectionInformation = this.getConnectionInformation(config);
        boolean tomcat7 = Boolean.valueOf(config.getValue(MULTI_REVISION_CAPABLE));
        Set<Application> applicationSet = this.createApplicationStatusMapping(config.toProperties(), connectionInformation.get(SERVICE_NAME), connectionInformation.get(HOST_NAME), tomcat7);
        this.LOGGER.debug((Object)("APPSET: " + applicationSet));
        return applicationSet;
    }

    private String performJmxOperation(String operationName, ApplicationIdentifier applicationIdentifier, Properties configProperties, Map<String, String> connectionInformation, String resultMessageTemplate) throws PluginException {
        String resultMessage;
        try {
            Object[] arguments;
            String[] types;
            String applicationPath = TomcatNameUtils.convertNameToPath((String)applicationIdentifier.getName());
            String objectName = this.getObjectName();
            boolean tcRuntime250OrLater = this.isTcRuntime250OrLater(objectName, operationName, 4, configProperties);
            if (tcRuntime250OrLater) {
                types = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};
                arguments = new Object[]{connectionInformation.get(SERVICE_NAME), connectionInformation.get(HOST_NAME), applicationPath, ApplicationUtils.convertVersionToPaddedString((int)applicationIdentifier.getVersion())};
            } else {
                types = new String[]{String.class.getName(), String.class.getName(), String.class.getName()};
                arguments = new Object[]{connectionInformation.get(SERVICE_NAME), connectionInformation.get(HOST_NAME), applicationPath};
            }
            this.mxUtil.invoke(configProperties, objectName, operationName, arguments, types);
            resultMessage = String.format(resultMessageTemplate, applicationIdentifier);
        }
        catch (RuntimeException e) {
            resultMessage = "Failure - " + this.createPluginException(e).getMessage();
        }
        catch (Exception e) {
            throw this.createPluginException(e);
        }
        return resultMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTcRuntime250OrLater(String objectName, String operationName, int expected25OrLaterArgumentCount, Properties config) throws PluginException {
        try {
            MBeanServerConnection mBeanServer = this.mxUtil.getMBeanServer(config);
            MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(new ObjectName(objectName));
            MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
            int n = mBeanOperationInfoArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                MBeanOperationInfo operationInfo = mBeanOperationInfoArray[n2];
                if (operationName.equals(operationInfo.getName()) && expected25OrLaterArgumentCount == operationInfo.getSignature().length) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw this.createPluginException(e);
        }
    }

    @Override
    public Map<String, Object> reload(ConfigResponse config) throws PluginException {
        Map<String, String> connectionInformation = this.getConnectionInformation(config);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String service = connectionInformation.get(SERVICE_NAME);
        String host = connectionInformation.get(HOST_NAME);
        Properties configProperties = config.toProperties();
        for (ApplicationIdentifier applicationIdentifier : this.getApplicationIdentifiers(config)) {
            String resultMessage = this.isApplicationRunning(applicationIdentifier, service, host, configProperties) ? this.performJmxOperation("reloadApplication", applicationIdentifier, configProperties, connectionInformation, "Ok - Application %s has reloaded.") : String.format("Failure - Application %s is not running.", applicationIdentifier);
            resultMap.put(applicationIdentifier.toString(), resultMessage);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> start(ConfigResponse config) throws PluginException {
        Map<String, String> connectionInformation = this.getConnectionInformation(config);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Properties configProperties = config.toProperties();
        for (ApplicationIdentifier applicationIdentifier : this.getApplicationIdentifiers(config)) {
            String host;
            String service;
            String resultMessage = this.isApplicationStopped(applicationIdentifier, service = connectionInformation.get(SERVICE_NAME), host = connectionInformation.get(HOST_NAME), configProperties) ? this.performJmxOperation("startApplication", applicationIdentifier, configProperties, connectionInformation, "Ok - Application %s has started.") : "Ok - Application " + applicationIdentifier + " is already running.";
            resultMap.put(applicationIdentifier.toString(), resultMessage);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> stop(ConfigResponse config) throws PluginException {
        Map<String, String> connectionInformation = this.getConnectionInformation(config);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Properties configProperties = config.toProperties();
        for (ApplicationIdentifier applicationIdentifier : this.getApplicationIdentifiers(config)) {
            String host;
            String service;
            String resultMessage = this.isApplicationRunning(applicationIdentifier, service = connectionInformation.get(SERVICE_NAME), host = connectionInformation.get(HOST_NAME), configProperties) ? this.performJmxOperation("stopApplication", applicationIdentifier, configProperties, connectionInformation, "Ok - Application %s has stopped.") : "Ok - Application " + applicationIdentifier + " is already stopped.";
            resultMap.put(applicationIdentifier.toString(), resultMessage);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> undeploy(ConfigResponse config) throws PluginException {
        Map<String, String> connectionInformation = this.getConnectionInformation(config);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String resultMessage = null;
        List<ApplicationIdentifier> applicationIdentifiers = this.getApplicationIdentifiers(config);
        for (ApplicationIdentifier applicationIdentifier : applicationIdentifiers) {
            try {
                Object[] arguments;
                String[] types;
                int numRetries = 3;
                int sleepTime = 3000;
                String applicationPath = TomcatNameUtils.convertNameToPath((String)applicationIdentifier.getName());
                String objectName = this.getObjectName();
                try {
                    if (this.isTcRuntime250OrLater(objectName, "undeployApplication", 4, config.toProperties())) {
                        types = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};
                        arguments = new Object[]{connectionInformation.get(SERVICE_NAME), connectionInformation.get(HOST_NAME), applicationPath, ApplicationUtils.convertVersionToPaddedString((int)applicationIdentifier.getVersion())};
                    } else {
                        types = new String[]{String.class.getName(), String.class.getName(), String.class.getName()};
                        arguments = new Object[]{connectionInformation.get(SERVICE_NAME), connectionInformation.get(HOST_NAME), applicationPath};
                    }
                }
                catch (Exception e) {
                    throw new PluginException((Throwable)e);
                }
                int i = 0;
                while (i < numRetries) {
                    this.LOGGER.debug((Object)("Undeploying app: " + applicationIdentifier));
                    this.mxUtil.invoke(config.toProperties(), objectName, "undeployApplication", arguments, types);
                    this.LOGGER.debug((Object)"The undeployApplication command has been executed");
                    Set<Application> applicationList = this.list(config);
                    this.LOGGER.debug((Object)"Checking if the app actually was undeployed");
                    ArrayList<ApplicationIdentifier> deployedAppsList = new ArrayList<ApplicationIdentifier>();
                    for (Application application : applicationList) {
                        deployedAppsList.add(new ApplicationIdentifier(application.getName(), application.getVersion()));
                    }
                    if (!deployedAppsList.contains(applicationIdentifier)) {
                        resultMessage = "Ok - Application " + applicationIdentifier + " has undeployed.";
                        numRetries = 0;
                    } else {
                        this.LOGGER.debug((Object)("The app named [" + applicationIdentifier + "] is still deployed"));
                        --numRetries;
                        this.LOGGER.debug((Object)("Sleeping for " + sleepTime));
                        Thread.currentThread();
                        Thread.sleep(sleepTime);
                    }
                    ++i;
                }
            }
            catch (ApplicationException e) {
                throw this.createPluginException(e);
            }
            catch (RuntimeException e) {
                resultMessage = "Failure - " + this.createPluginException(e).getMessage();
            }
            catch (InterruptedException e) {
                throw this.createPluginException(e);
            }
            resultMap.put(applicationIdentifier.toString(), resultMessage);
        }
        return resultMap;
    }

    @Override
    public String getAppBase(ConfigResponse config) throws PluginException {
        String baseDir = null;
        String appBase = null;
        if (this.mxUtil.checkConnection(config)) {
            try {
                Map<String, String> connectionInformation = this.getConnectionInformation(config);
                String objectName = String.valueOf(connectionInformation.get(SERVICE_NAME)) + ":type=Engine";
                baseDir = (String)this.mxUtil.getValue(config.toProperties(), objectName, "baseDir");
                objectName = String.valueOf(connectionInformation.get(SERVICE_NAME)) + ":type=Host,host=" + connectionInformation.get(HOST_NAME);
                appBase = (String)this.mxUtil.getValue(config.toProperties(), objectName, "appBase");
            }
            catch (MalformedObjectNameException e) {
                throw this.createPluginException(e);
            }
            catch (AttributeNotFoundException e) {
                throw this.createPluginException(e);
            }
            catch (InstanceNotFoundException e) {
                throw this.createPluginException(e);
            }
            catch (MalformedURLException e) {
                throw this.createPluginException(e);
            }
            catch (MBeanException e) {
                throw this.createPluginException(e);
            }
            catch (ReflectionException e) {
                throw this.createPluginException(e);
            }
            catch (IOException e) {
                throw this.createPluginException(e);
            }
        }
        if (baseDir == null || appBase == null) {
            StringBuilder message = new StringBuilder("The fully qualified appBase directory could not be assembled");
            message.append(" (baseDir=");
            if (baseDir == null) {
                message.append("null");
            } else {
                message.append(baseDir);
            }
            message.append(" appBase=");
            if (appBase == null) {
                message.append("null");
            } else {
                message.append(appBase);
            }
            message.append(")");
            throw new PluginException(message.toString());
        }
        return String.valueOf(baseDir) + "/" + appBase;
    }
}

