/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.appmgmt;

import com.springsource.hq.plugin.tcserver.plugin.appmgmt.FileOwnershipChanger;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.FilePermissionsChanger;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.ObjectNameUtils;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.ScriptingApplicationManager;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.domain.Application;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.domain.ApplicationStatus;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.domain.Host;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.domain.Service;
import com.springsource.hq.plugin.tcserver.plugin.wrapper.JmxUtils;
import com.springsource.hq.plugin.tcserver.util.application.ApplicationUtils;
import com.springsource.hq.plugin.tcserver.util.tomcat.TomcatNameUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.common.ApplicationException;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TomcatJmxScriptingApplicationManager
implements ScriptingApplicationManager {
    private static final String APPLICATION = "application";
    private static final String VERSION = "version";
    private static final String CONTEXT_PATH = "contextpath";
    private static final Set<String> DEFAULT_REQUIRED_VALUES = new HashSet<String>();
    private static final String HOST_NAME = "host";
    private static final String REMOTE_PATH = "remotepath";
    private static final String SERVICE_NAME = "service";
    private static final String APPLICATION_NAME = "name";
    private static final String APPLICATION_PATH = "path";
    private static final String APPLICATION_VERSION = "version";
    private final FilePermissionsChanger filePermissionsChanger;
    private final FileOwnershipChanger fileOwnershipChanger;
    private static final List<String> ROOT_APP_NAMES = new ArrayList<String>();
    private final Log LOGGER = LogFactory.getLog(TomcatJmxScriptingApplicationManager.class);
    private final JmxUtils mxUtil;

    static {
        DEFAULT_REQUIRED_VALUES.add(SERVICE_NAME);
        DEFAULT_REQUIRED_VALUES.add(HOST_NAME);
        ROOT_APP_NAMES.add("/");
        ROOT_APP_NAMES.add("/ROOT");
        ROOT_APP_NAMES.add("ROOT");
    }

    public TomcatJmxScriptingApplicationManager(JmxUtils jmxUtils, FilePermissionsChanger filePermissionsChanger, FileOwnershipChanger fileOwnershipChanger) {
        this.mxUtil = jmxUtils;
        this.filePermissionsChanger = filePermissionsChanger;
        this.fileOwnershipChanger = fileOwnershipChanger;
    }

    private boolean checkFileExists(String fileLocation) {
        boolean exists = false;
        try {
            exists = new File(fileLocation).isFile();
        }
        catch (Exception e) {
            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return exists;
    }

    private void checkRequiredValues(ConfigResponse config, Set<String> requiredValues) throws PluginException {
        requiredValues.addAll(DEFAULT_REQUIRED_VALUES);
        for (String requiredValue : requiredValues) {
            if (config.getKeys().contains(requiredValue)) continue;
            throw new PluginException("Required parameter '" + requiredValue + "' was not specified.");
        }
    }

    private PluginException createPluginException(Throwable throwable) throws PluginException {
        PluginException pluginException;
        if (throwable instanceof JMRuntimeException) {
            Throwable cause = throwable.getCause();
            pluginException = new PluginException(cause.getMessage(), cause);
        } else {
            pluginException = new PluginException(throwable.getMessage(), throwable);
        }
        return pluginException;
    }

    private Service createService(String serviceName, List<String> hostNames, ConfigResponse config) throws PluginException {
        Service service = new Service();
        service.setName(serviceName);
        boolean hasApplications = false;
        for (String hostName : hostNames) {
            Host host = new Host();
            host.setName(hostName);
            List<Application> applications = this.getApplications(serviceName, hostName, config);
            if (applications.isEmpty()) continue;
            host.getApplications().addAll(applications);
            service.getHosts().add(host);
            hasApplications = true;
        }
        if (!hasApplications) {
            if (config.getValue(APPLICATION) != null) {
                throw new PluginException("Application name specified was not found: " + config.getValue(APPLICATION));
            }
            service = null;
        }
        return service;
    }

    private String resolveContextPath(String originalContextPath) {
        String contextPath;
        for (String rootAppString : ROOT_APP_NAMES) {
            if (!rootAppString.equalsIgnoreCase(originalContextPath)) continue;
            return "";
        }
        String tempDeployPath = contextPath = originalContextPath.startsWith("/") ? originalContextPath : "/" + originalContextPath;
        if (contextPath.indexOf("##") > 0) {
            tempDeployPath = contextPath.substring(0, contextPath.indexOf("##"));
        }
        return tempDeployPath;
    }

    @Override
    public List<ApplicationStatus> deploy(ConfigResponse config) throws PluginException {
        String resultMessage;
        HashSet<String> requiredValues = new HashSet<String>();
        requiredValues.add(CONTEXT_PATH);
        requiredValues.add(REMOTE_PATH);
        this.checkRequiredValues(config, requiredValues);
        Map<String, String> connectionInformation = this.getConnectionInformation(config.getValue(SERVICE_NAME), config.getValue(HOST_NAME), config);
        ArrayList<ApplicationStatus> statusListing = new ArrayList<ApplicationStatus>();
        String contextPath = this.resolveContextPath(config.getValue(CONTEXT_PATH));
        String applicationLocation = config.getValue(REMOTE_PATH);
        this.LOGGER.debug((Object)("contextpath - " + contextPath + "  application -  " + applicationLocation));
        boolean hasError = false;
        if (this.checkFileExists(applicationLocation)) {
            File warFile = new File(applicationLocation);
            this.filePermissionsChanger.changeFilePermissions(warFile);
            this.fileOwnershipChanger.changeFileOwnership(warFile, config.getValue("process.username"), config.getValue("process.group"));
            try {
                String objectName = this.getObjectName();
                if (this.isTcRuntime250OrLater(objectName, "deployApplication", 5, config) && Boolean.valueOf(config.getValue("MULTI_REVISION_CAPABLE")).booleanValue()) {
                    String version = this.getNextApplicationVersion(contextPath, connectionInformation, config);
                    this.mxUtil.invoke(config.toProperties(), objectName, "deployApplication", new Object[]{connectionInformation.get(SERVICE_NAME), connectionInformation.get(HOST_NAME), contextPath, version, applicationLocation}, new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
                    resultMessage = String.format("Ok - Application '%s', revision '%s has deployed", contextPath, version);
                }
                this.mxUtil.invoke(config.toProperties(), objectName, "deployApplication", new Object[]{connectionInformation.get(SERVICE_NAME), connectionInformation.get(HOST_NAME), contextPath, applicationLocation}, new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
                resultMessage = String.format("Ok - Application %s has deployed.", contextPath);
            }
            catch (ApplicationException e) {
                throw this.createPluginException(e);
            }
            catch (JMException e) {
                throw this.createPluginException(e);
            }
            catch (IOException e) {
                throw this.createPluginException(e);
            }
            catch (RuntimeException e) {
                resultMessage = String.format("Failure - %s", this.createPluginException(e).getMessage());
                hasError = true;
            }
        } else {
            resultMessage = String.format("Failure - Application %s failed to deploy - No file exists at location: %s", contextPath, applicationLocation);
            hasError = true;
        }
        ApplicationStatus applicationStatus = new ApplicationStatus();
        applicationStatus.setResultMessage(resultMessage);
        applicationStatus.setApplicationName(contextPath);
        applicationStatus.setHasError(hasError);
        statusListing.add(applicationStatus);
        return statusListing;
    }

    private String getNextApplicationVersion(String path, Map<String, String> connectionInformation, ConfigResponse config) throws JMException, IOException, PluginException, ApplicationException {
        int latestVersion = -1;
        Set applicationMetadatas = (Set)this.mxUtil.invoke(config.toProperties(), this.getObjectName(), "listApplications", new Object[]{connectionInformation.get(SERVICE_NAME), connectionInformation.get(HOST_NAME)}, new String[]{String.class.getName(), String.class.getName()});
        for (Map applicationMetadata : applicationMetadatas) {
            String applicationVersion;
            int version;
            String applicationPath = (String)applicationMetadata.get(APPLICATION_PATH);
            if (!path.equals(applicationPath) || (version = "".equals(applicationVersion = (String)applicationMetadata.get("version")) ? 0 : Integer.parseInt(applicationVersion)) <= latestVersion) continue;
            latestVersion = version;
        }
        if (latestVersion == -1) {
            return "";
        }
        return String.format("%06d", latestVersion + 1);
    }

    private List<ApplicationStatus> executeCommand(ConfigResponse config, String command, String messageSuffix, Set<String> requiredValues) throws PluginException {
        this.checkRequiredValues(config, requiredValues);
        Map<String, String> connectionInformation = this.getConnectionInformation(config.getValue(SERVICE_NAME), config.getValue(HOST_NAME), config);
        ArrayList<ApplicationStatus> statusListing = new ArrayList<ApplicationStatus>();
        boolean hasError = false;
        Iterator<String> iterator = this.getApplicationNames(config).iterator();
        while (iterator.hasNext()) {
            String resultMessage;
            String appName;
            String applicationName = appName = iterator.next();
            if (appName.equals("/ROOT") || appName.equals("/")) {
                applicationName = "";
            }
            try {
                String service = connectionInformation.get(SERVICE_NAME);
                String host = connectionInformation.get(HOST_NAME);
                this.LOGGER.debug((Object)(String.valueOf(command) + " = " + service + " " + host + " " + applicationName));
                String objectName = this.getObjectName();
                if (this.isTcRuntime250OrLater(objectName, command, 4, config)) {
                    String version = config.getValue("version");
                    if (this.isApplicationRevisionAdequatelySpecified(applicationName, version, service, host, config)) {
                        if (version != null && !"".equals(version)) {
                            version = ApplicationUtils.convertVersionToPaddedString((String)version);
                        }
                        this.mxUtil.invoke(config.toProperties(), objectName, command, new Object[]{service, host, applicationName, version}, new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
                        resultMessage = String.format("Ok - Application '%s', revision '%s has %s", applicationName, version, messageSuffix);
                    } else {
                        resultMessage = "Failure - multiple revisions of '" + appName + "' are present but no revision was specified";
                        hasError = true;
                    }
                } else {
                    this.mxUtil.invoke(config.toProperties(), objectName, command, new Object[]{service, host, applicationName}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()});
                    resultMessage = String.format("Ok - Application '%s' has %s", applicationName, messageSuffix);
                }
            }
            catch (ApplicationException e) {
                throw this.createPluginException(e);
            }
            catch (IOException e) {
                throw this.createPluginException(e);
            }
            catch (JMException e) {
                throw this.createPluginException(e);
            }
            catch (RuntimeException e) {
                resultMessage = "Failure - " + this.createPluginException(e).getMessage();
                hasError = true;
            }
            statusListing.add(this.createApplicationStatus(applicationName, resultMessage, hasError));
        }
        return statusListing;
    }

    private boolean isApplicationRevisionAdequatelySpecified(String applicationName, String version, String service, String host, ConfigResponse config) throws PluginException {
        if (version == null || "".equals(version)) {
            int revisionCount = 0;
            for (Application application : this.getApplications(service, host, config)) {
                if (!applicationName.equals(application.getName())) continue;
                ++revisionCount;
            }
            return revisionCount <= 1;
        }
        return true;
    }

    private ApplicationStatus createApplicationStatus(String applicationName, String resultMessage, boolean hasError) {
        ApplicationStatus applicationStatus = new ApplicationStatus();
        applicationStatus.setResultMessage(resultMessage);
        applicationStatus.setApplicationName(applicationName);
        applicationStatus.setHasError(hasError);
        return applicationStatus;
    }

    private List<String> getApplicationNames(ConfigResponse config) {
        Set keys = config.getKeys();
        this.LOGGER.debug((Object)("KEYS = " + keys));
        ArrayList<String> applicationNames = new ArrayList<String>();
        int i = 1;
        while (i < keys.size()) {
            if (keys.contains(APPLICATION + i)) {
                this.LOGGER.debug((Object)("FOUND " + i + "." + config.getValue(APPLICATION + i)));
                applicationNames.add(this.validateApplicationName(config.getValue(APPLICATION + i)));
            }
            ++i;
        }
        return applicationNames;
    }

    protected String getApplicationObjectName(String path, String host) {
        String applicationPath = path;
        if (path.equals("")) {
            applicationPath = "/";
        }
        return String.format("Catalina:type=Manager,path=%s,host=%s", applicationPath, host);
    }

    private List<Application> getApplications(String service, String host, ConfigResponse config) throws PluginException {
        String applicationNameFilter = this.validateApplicationName(config.getValue(APPLICATION));
        ArrayList<Application> applications = new ArrayList<Application>();
        try {
            Map<String, String> connectionInformation = this.getConnectionInformation(service, host, config);
            Object applicationsObject = this.mxUtil.invoke(config.toProperties(), this.getObjectName(), "listApplications", new Object[]{connectionInformation.get(SERVICE_NAME), connectionInformation.get(HOST_NAME)}, new String[]{String.class.getName(), String.class.getName()});
            if (this.isTcRuntime25OrLater(applicationsObject)) {
                applications.addAll(this.getApplications((Set)applicationsObject, applicationNameFilter, connectionInformation, config));
            } else {
                applications.addAll(this.getApplications((String[])applicationsObject, applicationNameFilter, connectionInformation, config));
            }
        }
        catch (ApplicationException e) {
            this.createPluginException(e);
        }
        catch (PluginException e) {
            throw e;
        }
        catch (IOException e) {
            this.createPluginException(e);
        }
        catch (JMException e) {
            this.createPluginException(e);
        }
        return applications;
    }

    private List<Application> getApplications(Set<Map<String, String>> applicationMetadatas, String applicationNameFilter, Map<String, String> connectionInformation, ConfigResponse config) throws ApplicationException, PluginException, IOException, JMException {
        ArrayList<Application> applications = new ArrayList<Application>();
        boolean tomcat7 = Boolean.valueOf(config.getValue("MULTI_REVISION_CAPABLE"));
        for (Map<String, String> applicationMetadata : applicationMetadatas) {
            String applicationName = applicationMetadata.get(APPLICATION_NAME);
            if (applicationNameFilter != null && !applicationNameFilter.equals(applicationName)) continue;
            String path = applicationMetadata.get(APPLICATION_PATH);
            String version = applicationMetadata.get("version");
            String hostName = connectionInformation.get(HOST_NAME);
            String serviceName = connectionInformation.get(SERVICE_NAME);
            try {
                Application application = new Application();
                application.setName(TomcatNameUtils.convertPathToName((String)path));
                application.setStatus(this.getApplicationStatus(connectionInformation, config, path, version));
                if (version != null && version.length() > 0) {
                    application.setVersion(Integer.parseInt(version));
                } else {
                    application.setVersion(0);
                }
                String objectName = ObjectNameUtils.getManagerMBeanObjectNameForApplication(hostName, application, tomcat7);
                application.setSessionCount(this.getSessionCount(objectName, config));
                applications.add(application);
            }
            catch (Exception e) {
                this.LOGGER.warn((Object)String.format("Failed to collect details for application '%s' deployed on service '%s' and host '%s'", applicationName, serviceName, hostName), (Throwable)e);
            }
        }
        return applications;
    }

    private List<Application> getApplications(String[] applicationNames, String applicationNameFilter, Map<String, String> connectionInformation, ConfigResponse config) throws ApplicationException, PluginException, JMException, IOException {
        ArrayList<Application> applications = new ArrayList<Application>();
        String[] stringArray = applicationNames;
        int n = applicationNames.length;
        int n2 = 0;
        while (n2 < n) {
            String applicationName = stringArray[n2];
            if (applicationNameFilter == null || applicationNameFilter.equals(applicationName)) {
                Application application = new Application();
                application.setName(applicationName.equals("") ? "ROOT" : applicationName.substring(1));
                application.setStatus(this.getApplicationStatus(connectionInformation, config, applicationName));
                String objectName = ObjectNameUtils.getManagerMBeanObjectNameForApplication(connectionInformation.get(HOST_NAME), application, false);
                application.setSessionCount(this.getSessionCount(objectName, config));
                applications.add(application);
            }
            ++n2;
        }
        return applications;
    }

    private int getSessionCount(String objectName, ConfigResponse config) throws JMException, PluginException, IOException {
        if (this.isMBeanRegistered(objectName, config)) {
            return (Integer)this.mxUtil.getValue(config.toProperties(), objectName, "activeSessions");
        }
        return 0;
    }

    private boolean isMBeanRegistered(String objectName, ConfigResponse config) throws IOException, MalformedObjectNameException {
        return this.mxUtil.getMBeanServer(config.toProperties()).isRegistered(new ObjectName(objectName));
    }

    private String getApplicationStatus(Map<String, String> connectionInformation, ConfigResponse config, String applicationName) throws ApplicationException, PluginException {
        return this.getOverallStatus((String)this.mxUtil.invoke(config.toProperties(), this.getObjectName(), "getApplicationState", new Object[]{connectionInformation.get(SERVICE_NAME), connectionInformation.get(HOST_NAME), applicationName}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()}));
    }

    private String getApplicationStatus(Map<String, String> connectionInformation, ConfigResponse config, String path, String version) throws ApplicationException, PluginException {
        return this.getOverallStatus((String)this.mxUtil.invoke(config.toProperties(), this.getObjectName(), "getApplicationState", new Object[]{connectionInformation.get(SERVICE_NAME), connectionInformation.get(HOST_NAME), path, version}, new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()}));
    }

    private Map<String, String> getConnectionInformation(String serviceName, String hostName, ConfigResponse config) throws PluginException {
        LinkedHashMap<String, String> connectionInformation = new LinkedHashMap<String, String>();
        if (this.mxUtil.checkConnection(config)) {
            connectionInformation.put(SERVICE_NAME, serviceName);
            connectionInformation.put(HOST_NAME, hostName);
            this.LOGGER.debug((Object)("ConnectionInfo: SERVICE_NAME = " + serviceName + ", HOST_NAME = " + hostName));
            boolean canExecute = false;
            try {
                String[] services = (String[])this.mxUtil.invoke(config.toProperties(), this.getObjectName(), "getServices", new Object[0], new String[0]);
                if (Arrays.asList(services).contains(serviceName) && Arrays.asList((String[])this.mxUtil.invoke(config.toProperties(), this.getObjectName(), "getHosts", new Object[]{serviceName}, new String[]{String.class.getName()})).contains(hostName)) {
                    canExecute = true;
                }
            }
            catch (ApplicationException e) {
                throw this.createPluginException(e);
            }
            if (!canExecute) {
                throw new PluginException("The service name (" + serviceName + ") and host name (" + hostName + ") does not match any services on this resource. " + "The resource server configuration may be out of sync with the other group members.");
            }
        } else {
            throw new PluginException("Unable to connect to the instance. Please verify the instance is running and whether the JMX configuration is correct.");
        }
        return connectionInformation;
    }

    private List<String> getHosts(String service, ConfigResponse config) throws ApplicationException, PluginException {
        String[] hosts = (String[])this.mxUtil.invoke(config.toProperties(), this.getObjectName(), "getHosts", new Object[]{service}, new String[]{String.class.getName()});
        return Arrays.asList(hosts);
    }

    protected String getObjectName() {
        return "tcServer:type=Serviceability,name=Deployer";
    }

    private String getOverallStatus(String detailedStatus) {
        String overallStatus = "Stopped";
        this.LOGGER.debug((Object)("DETAILED STATUS = " + detailedStatus));
        if (detailedStatus.equals("AVAILABLE") || detailedStatus.equals("STARTED")) {
            overallStatus = "Running";
        }
        return overallStatus;
    }

    @Override
    public Map<String, List<String>> getServiceHostMappings(ConfigResponse config) throws PluginException {
        if (this.mxUtil.checkConnection(config)) {
            try {
                List<String> allServices = this.getServices(config);
                ArrayList<String> queryServices = new ArrayList<String>();
                if (config.getValue(SERVICE_NAME) == null) {
                    queryServices.addAll(allServices);
                } else if (allServices.contains(config.getValue(SERVICE_NAME))) {
                    queryServices.add(config.getValue(SERVICE_NAME));
                } else {
                    throw new PluginException("Service name specified was not found: " + config.getValue(SERVICE_NAME));
                }
                return this.getServiceHostMappings(queryServices, config);
            }
            catch (ApplicationException e) {
                throw this.createPluginException(e);
            }
        }
        throw new PluginException("Unable to connect to the instance. Please verify the instance is running and whether the JMX configuration is correct.");
    }

    private Map<String, List<String>> getServiceHostMappings(List<String> services, ConfigResponse config) throws PluginException, ApplicationException {
        LinkedHashMap<String, List<String>> serviceHostMapping = new LinkedHashMap<String, List<String>>();
        boolean hostFound = false;
        for (String service : services) {
            List<String> allHosts = this.getHosts(service, config);
            List<Object> hosts = new ArrayList();
            if (config.getValue(HOST_NAME) == null) {
                hosts = allHosts;
            } else if (allHosts.contains(config.getValue(HOST_NAME))) {
                hosts = new ArrayList(1);
                hosts.add(config.getValue(HOST_NAME));
            }
            if (hosts.isEmpty()) continue;
            serviceHostMapping.put(service, hosts);
            hostFound = true;
        }
        if (!hostFound) {
            throw new PluginException("Host name specified was not found: " + config.getValue(HOST_NAME));
        }
        return serviceHostMapping;
    }

    private List<String> getServices(ConfigResponse config) throws ApplicationException, PluginException {
        String[] services = (String[])this.mxUtil.invoke(config.toProperties(), this.getObjectName(), "getServices", new Object[0], new String[0]);
        return Arrays.asList(services);
    }

    @Override
    public List<Service> list(ConfigResponse config) throws PluginException {
        ArrayList<Service> serviceListing = new ArrayList<Service>();
        for (Map.Entry<String, List<String>> serviceHostEntry : this.getServiceHostMappings(config).entrySet()) {
            Service service = this.createService(serviceHostEntry.getKey(), serviceHostEntry.getValue(), config);
            if (service == null) continue;
            serviceListing.add(service);
        }
        return serviceListing;
    }

    @Override
    public List<ApplicationStatus> reload(ConfigResponse config) throws PluginException {
        HashSet<String> requiredValues = new HashSet<String>();
        requiredValues.add("application1");
        return this.executeCommand(config, "reloadApplication", "reloaded", requiredValues);
    }

    @Override
    public List<ApplicationStatus> start(ConfigResponse config) throws PluginException {
        HashSet<String> requiredValues = new HashSet<String>();
        requiredValues.add("application1");
        return this.executeCommand(config, "startApplication", "started", requiredValues);
    }

    @Override
    public List<ApplicationStatus> stop(ConfigResponse config) throws PluginException {
        HashSet<String> requiredValues = new HashSet<String>();
        requiredValues.add("application1");
        return this.executeCommand(config, "stopApplication", "stopped", requiredValues);
    }

    @Override
    public List<ApplicationStatus> undeploy(ConfigResponse config) throws PluginException {
        HashSet<String> requiredValues = new HashSet<String>();
        requiredValues.add("application1");
        return this.executeCommand(config, "undeployApplication", "undeployed", requiredValues);
    }

    private String validateApplicationName(String applicationName) {
        String validatedName = applicationName;
        if (applicationName != null) {
            if (applicationName.equals("/") || applicationName.equals("/ROOT") || applicationName.equals("ROOT")) {
                validatedName = "";
            } else if (!applicationName.startsWith("/")) {
                validatedName = "/" + applicationName;
            }
        }
        return validatedName;
    }

    private boolean isTcRuntime25OrLater(Object applicationsObj) {
        return applicationsObj instanceof Set;
    }

    private boolean isTcRuntime250OrLater(String objectName, String operationName, int expected25OrLaterArgumentCount, ConfigResponse config) throws JMException, IOException {
        MBeanServerConnection mBeanServer = this.mxUtil.getMBeanServer(config.toProperties());
        MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(new ObjectName(objectName));
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        int n = mBeanOperationInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanOperationInfo operationInfo = mBeanOperationInfoArray[n2];
            if (operationInfo.getName().equals(operationName) && expected25OrLaterArgumentCount == operationInfo.getSignature().length) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

