/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig;

import com.springsource.hq.plugin.tcserver.plugin.appmgmt.FileOwnershipChanger;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.FilePermissionsChanger;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.StandardFileOwnershipChangerFactory;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.StandardFilePermissionsChangerFactory;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.ContextXmlParser;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.FileUtility;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.FileUtilityException;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.ServerXmlParser;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.SettingsRepository;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.WebXmlParser;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlParser;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.context.ContextContainerConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.EnvironmentRepository;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.UnixFileEnvironmentRepository;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.WindowsFileEnvironmentRepository;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.general.GeneralConfigConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.resources.jdbc.DataSourcesConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.serverdefaults.ServerDefaultsConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.ServicesConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.Settings;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.context.ContextContainer;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.general.GeneralConfig;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.Environment;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.serverdefaults.ServerDefaults;
import com.springsource.hq.plugin.tcserver.serverconfig.resources.jdbc.DataSource;
import com.springsource.hq.plugin.tcserver.serverconfig.services.Service;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FileSettingsRepository
implements SettingsRepository {
    private XmlElementConverter<ContextContainer> contextContainerConverter = new ContextContainerConverter();
    private XmlParser contextXmlParser = new ContextXmlParser();
    private XmlElementConverter<Set<DataSource>> dataSourcesConverter = new DataSourcesConverter();
    private XmlElementConverter<GeneralConfig> generalConfigConverter = new GeneralConfigConverter();
    private final Log logger = LogFactory.getLog(FileSettingsRepository.class);
    private XmlElementConverter<ServerDefaults> serverDefaultsConverter = new ServerDefaultsConverter();
    private XmlParser serverXmlParser = new ServerXmlParser();
    private XmlElementConverter<Set<Service>> servicesConverter = new ServicesConverter();
    private EnvironmentRepository environmentRepository = PlatformDetector.IS_WIN32 ? new WindowsFileEnvironmentRepository() : new UnixFileEnvironmentRepository();
    private XmlParser webXmlParser = new WebXmlParser();
    private FileUtility fileUtility = new FileUtility();
    private final FilePermissionsChanger filePermissionsChanger;
    private final FileOwnershipChanger fileOwnershipChanger;

    public FileSettingsRepository() throws PluginException {
        this(new StandardFileOwnershipChangerFactory().getFileOwnershipChanger(), new StandardFilePermissionsChangerFactory().getFilePermissionsChanger());
    }

    public FileSettingsRepository(FileOwnershipChanger fileOwnershipChanger, FilePermissionsChanger filePermissionsChanger) throws PluginException {
        this.fileOwnershipChanger = fileOwnershipChanger;
        this.filePermissionsChanger = filePermissionsChanger;
    }

    private boolean checkAndCreateParentDirectories(String installPath, String filePath) throws PluginException {
        boolean canWrite = new File(installPath).canWrite();
        boolean exists = false;
        if (canWrite) {
            String absoluteDirectory = filePath.substring(0, filePath.lastIndexOf(47));
            File directory = new File(absoluteDirectory);
            exists = directory.exists();
            if (!exists) {
                try {
                    exists = directory.mkdirs();
                }
                catch (SecurityException e) {
                    throw new PluginException("Unable to create directory structure '" + absoluteDirectory + "': " + e.getMessage());
                }
            } else if (!directory.canWrite()) {
                throw new PluginException("Unable to write to directory: " + absoluteDirectory);
            }
        } else {
            throw new PluginException("Unable to write to directory:" + installPath);
        }
        return exists;
    }

    private String copyBackupEnvironmentFile(ConfigResponse config) throws FileNotFoundException, IOException {
        Date date = new Date();
        if (PlatformDetector.IS_WIN32) {
            return this.fileUtility.copyBackupFile(Metric.decode((String)config.getValue("installpath")), "/conf", "wrapper.conf", date);
        }
        String setenv = String.valueOf(Metric.decode((String)config.getValue("installpath"))) + "/bin/setenv.sh";
        if (new File(setenv).exists()) {
            return this.fileUtility.copyBackupFile(Metric.decode((String)config.getValue("installpath")), "/bin", "setenv.sh", date);
        }
        return null;
    }

    private String copyBackupFiles(ConfigResponse config) throws FileNotFoundException, IOException {
        Date date = new Date();
        this.fileUtility.copyBackupFile(Metric.decode((String)config.getValue("installpath")), "/conf", "server.xml", date);
        this.fileUtility.copyBackupFile(Metric.decode((String)config.getValue("installpath")), "/conf", "context.xml", date);
        this.fileUtility.copyBackupFile(Metric.decode((String)config.getValue("installpath")), "/conf", "web.xml", date);
        if (PlatformDetector.IS_WIN32) {
            return this.fileUtility.copyBackupFile(Metric.decode((String)config.getValue("installpath")), "/conf", "wrapper.conf", date);
        }
        String setenv = String.valueOf(Metric.decode((String)config.getValue("installpath"))) + "/bin/setenv.sh";
        if (new File(setenv).exists()) {
            return this.fileUtility.copyBackupFile(Metric.decode((String)config.getValue("installpath")), "/bin", "setenv.sh", date);
        }
        return null;
    }

    public void copyFile(ConfigResponse config) throws PluginException {
        block20: {
            String sourcePath = config.getValue("SOURCE");
            String destinationPath = config.getValue("DESTINATION");
            InputStream in = null;
            FileOutputStream out = null;
            try {
                try {
                    File sourceFile = new File(sourcePath);
                    in = new FileInputStream(sourceFile);
                    File destFile = new File(destinationPath);
                    out = new FileOutputStream(destFile);
                    this.fileUtility.copyFiles(in, out);
                    out.flush();
                    out.getFD().sync();
                    this.filePermissionsChanger.changeFilePermissions(destFile);
                    this.fileOwnershipChanger.changeFileOwnership(destFile, config.getValue("process.username"), config.getValue("process.group"));
                }
                catch (IOException e) {
                    this.logger.warn((Object)("An error occured with a stream: " + e.getMessage()), (Throwable)e);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            this.logger.warn((Object)("An error occurred upon closing the input stream: " + e2.getMessage()), (Throwable)e2);
                        }
                    }
                    if (out == null) break block20;
                    try {
                        out.close();
                    }
                    catch (IOException e3) {
                        this.logger.warn((Object)("An error occurred upon closing the output stream: " + e3.getMessage()));
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.logger.warn((Object)("An error occurred upon closing the input stream: " + e.getMessage()), (Throwable)e);
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        this.logger.warn((Object)("An error occurred upon closing the output stream: " + e.getMessage()));
                    }
                }
            }
        }
    }

    public boolean fileExists(ConfigResponse config) throws PluginException {
        return new File(config.getValue("FILENAME")).exists();
    }

    private String createSanitizedPath(String path, String file) throws PluginException {
        if (file.contains("..")) {
            throw new PluginException("The file cannot contain '..'.");
        }
        StringBuilder fullPath = new StringBuilder();
        fullPath.append(path);
        if (!file.startsWith("/")) {
            fullPath.append("/");
        }
        fullPath.append(file);
        return fullPath.toString();
    }

    private Properties loadCatalinaProperties(ConfigResponse config) throws IOException {
        FileSystemResource propResource = new FileSystemResource(String.valueOf(Metric.decode((String)config.getValue("installpath"))) + "/conf/catalina.properties");
        Properties catalinaProperties = propResource.exists() ? PropertiesLoaderUtils.loadProperties((Resource)propResource) : new Properties();
        catalinaProperties.put("catalina.home", Metric.decode((String)config.getValue("catalina.home")));
        catalinaProperties.put("catalina.base", Metric.decode((String)config.getValue("installpath")));
        return catalinaProperties;
    }

    public void prepareFile(ConfigResponse config) throws PluginException {
        boolean createBackup;
        String installPath = Metric.decode((String)config.getValue("installpath"));
        String filePath = this.createSanitizedPath(installPath, config.getValue("FILE_NAME"));
        boolean bl = createBackup = config.getValue("nobackupfile") == null || config.getValue("nobackupfile").equals("false");
        if (this.checkAndCreateParentDirectories(installPath, filePath)) {
            if (createBackup) {
                try {
                    String baseDirUrl = Metric.decode((String)config.getValue("installpath"));
                    String fileName = config.getValue("FILE_NAME");
                    this.fileUtility.copyBackupFile(baseDirUrl, fileName);
                }
                catch (Exception e) {
                    throw new PluginException("Unable to save file. An error occurred while creating a backup of the existing file.  Cause: " + e.getMessage());
                }
            }
        } else {
            throw new PluginException("Unable to find or create directory structure for file: " + filePath + ". Check file and directory permissions.");
        }
    }

    public void putFile(ConfigResponse config) throws PluginException {
        String fileData = config.getValue("FILE_DATA");
        String filename = this.createSanitizedPath(Metric.decode((String)config.getValue("installpath")), config.getValue("FILE_NAME"));
        try {
            this.fileUtility.copyBackupFile(Metric.decode((String)config.getValue("installpath")), config.getValue("FILE_NAME"));
        }
        catch (Exception e) {
            throw new PluginException("Unable to put file.  An error occurred while creating a backup of the existing file.  Cause: " + e.getMessage());
        }
        try {
            this.writeFileFromBase64(fileData, filename);
        }
        catch (IOException e) {
            throw new PluginException("Unable to put file.  An error occurred while writing to the file.  A backup file with timestamp was saved.  You may need to manually revert.  Cause: " + e.getMessage());
        }
    }

    public void revertToPreviousConfiguration(ConfigResponse config) throws PluginException {
        TreeSet backupSet = (TreeSet)this.fileUtility.getLatestBackupDirectories(config.getValue("installpath"));
        if (!backupSet.isEmpty()) {
            try {
                this.fileUtility.revertToBackupFiles(config.getValue("installpath"), (String)backupSet.last());
            }
            catch (FileUtilityException e) {
                throw new PluginException(e.getMessage());
            }
        } else {
            throw new PluginException("Unable to revert to backup files: No backup directories found in " + new File(config.getValue("installpath"), "backup").getAbsolutePath());
        }
    }

    public void saveConfiguration(ConfigResponse config, Settings settings) throws PluginException {
        Document contextXml;
        Document webXml;
        Document serverXml;
        Properties catalinaProperties;
        String setenvOrWrapperConfBackupFile;
        try {
            setenvOrWrapperConfBackupFile = this.copyBackupFiles(config);
        }
        catch (Exception e) {
            throw new PluginException("Error creating backup file.  Configuration was not saved.  Cause: " + e.getMessage());
        }
        try {
            catalinaProperties = this.loadCatalinaProperties(config);
        }
        catch (Exception e) {
            throw new PluginException("Error parsing existing catalina.properties.  Configuration was not saved.  Cause: " + e.getMessage(), (Throwable)e);
        }
        try {
            serverXml = this.updateServerConfiguration(settings, config, catalinaProperties);
        }
        catch (Exception e) {
            throw new PluginException("Error parsing existing server.xml to perform updates.  Configuration was not saved.  Cause: " + e.getMessage(), (Throwable)e);
        }
        try {
            webXml = this.updateWebConfiguration(settings, config, catalinaProperties);
        }
        catch (Exception e) {
            throw new PluginException("Error parsing existing web.xml to perform updates.  Configuration was not saved.  Cause: " + e.getMessage(), (Throwable)e);
        }
        try {
            contextXml = this.updateContextConfiguration(settings, config, catalinaProperties);
        }
        catch (Exception e) {
            throw new PluginException("Error parsing existing context.xml to perform updates.  Configuration was not saved.  Cause: " + e.getMessage(), (Throwable)e);
        }
        this.writeFiles(config, serverXml, webXml, contextXml);
        if (setenvOrWrapperConfBackupFile == null) {
            this.environmentRepository.save(config, settings.getConfiguration().getEnvironment());
        } else {
            this.environmentRepository.save(setenvOrWrapperConfBackupFile, config, settings.getConfiguration().getEnvironment());
        }
    }

    public void saveEnvironment(ConfigResponse config, Environment environment) throws PluginException {
        String setenvOrWrapperConfBackupFile;
        try {
            setenvOrWrapperConfBackupFile = this.copyBackupEnvironmentFile(config);
        }
        catch (Exception e) {
            throw new PluginException("Error creating backup file.  Configuration was not saved.  Cause: " + e.getMessage());
        }
        if (setenvOrWrapperConfBackupFile == null) {
            this.environmentRepository.save(config, environment);
        } else {
            this.environmentRepository.save(setenvOrWrapperConfBackupFile, config, environment);
        }
    }

    private Document updateContextConfiguration(Settings settings, ConfigResponse config, Properties catalinaProperties) throws ParserConfigurationException, SAXException, IOException, PluginException {
        Document contextXml = this.contextXmlParser.createDocument(config);
        Element context = this.contextXmlParser.parse(contextXml);
        this.contextContainerConverter.convert(contextXml, context, settings.getConfiguration().getContextContainer(), catalinaProperties);
        return contextXml;
    }

    private Document updateServerConfiguration(Settings settings, ConfigResponse config, Properties catalinaProperties) throws ParserConfigurationException, SAXException, IOException, TransformerException, PluginException {
        Document serverXml = this.serverXmlParser.createDocument(config);
        Element server = this.serverXmlParser.parse(serverXml);
        this.generalConfigConverter.convert(serverXml, server, settings.getConfiguration().getGeneralConfig(), catalinaProperties);
        this.dataSourcesConverter.convert(serverXml, server, settings.getDataSources(), catalinaProperties);
        this.servicesConverter.convert(serverXml, server, settings.getServices(), catalinaProperties);
        return serverXml;
    }

    private Document updateWebConfiguration(Settings settings, ConfigResponse config, Properties catalinaProperties) throws ParserConfigurationException, SAXException, IOException, PluginException {
        Document webXml = this.webXmlParser.createDocument(config);
        Element webApp = this.webXmlParser.parse(webXml);
        this.serverDefaultsConverter.convert(webXml, webApp, settings.getConfiguration().getServerDefaults(), catalinaProperties);
        return webXml;
    }

    private void writeFileFromBase64(String text, String destinationFile) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(destinationFile));
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.decodeBase64((byte[])text.getBytes()));
            this.fileUtility.copyFiles(in, out);
            out.flush();
            out.getFD().sync();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logger.warn((Object)("Error closing output stream to file: " + destinationFile + ".  Cause: " + e.getMessage()));
                }
            }
        }
    }

    private void writeFiles(ConfigResponse config, Document serverXml, Document webXml, Document contextXml) throws PluginException {
        HashMap<String, String> failures = new HashMap<String, String>();
        try {
            this.serverXmlParser.writeDocument(serverXml, config);
        }
        catch (Exception e) {
            failures.put("server.xml", e.getMessage());
        }
        try {
            this.webXmlParser.writeDocument(webXml, config);
        }
        catch (Exception e) {
            failures.put("web.xml", e.getMessage());
        }
        try {
            this.contextXmlParser.writeDocument(contextXml, config);
        }
        catch (Exception e) {
            failures.put("context.xml", e.getMessage());
        }
        if (!failures.isEmpty()) {
            StringBuilder exceptionText = new StringBuilder();
            for (Map.Entry failureEntry : failures.entrySet()) {
                exceptionText.append("Failed to write Configuration to file: ").append((String)failureEntry.getKey()).append(".  Cause: ").append((String)failureEntry.getValue());
            }
            throw new PluginException(exceptionText.toString());
        }
    }
}

