/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.DefaultJvmOptionsConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.EnvironmentFactory;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.JvmOptionsConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.WindowsSpecificNonJvmOptsUtil;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.Environment;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.JvmOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class WindowsFileReadingEnvironmentFactory
implements EnvironmentFactory {
    private JvmOptionsConverter jvmOptionsConverter = new DefaultJvmOptionsConverter();
    private WindowsSpecificNonJvmOptsUtil windowsOptsUtil = new WindowsSpecificNonJvmOptsUtil();

    public Environment create(ConfigResponse config) throws PluginException {
        try {
            Environment environment = new Environment();
            FileSystemResource wrapperConf = new FileSystemResource(String.valueOf(Metric.decode((String)config.getValue("installpath"))) + "/conf/wrapper.conf");
            if (wrapperConf.exists()) {
                environment.setJvmOptions(this.createJvmOptions((Resource)wrapperConf));
                environment.setJavaHome(this.createJavaHome((Resource)wrapperConf));
                return environment;
            }
            return environment;
        }
        catch (Exception e) {
            throw new PluginException("Unable to read existing tc Runtime configuration.  Cause: " + e.getMessage());
        }
    }

    private JvmOptions createJvmOptions(Resource wrapperConf) throws IOException {
        BufferedReader envFileReader = new BufferedReader(new InputStreamReader(wrapperConf.getInputStream()));
        try {
            List<String> jvmOpts = new LinkedList<String>();
            String line = envFileReader.readLine();
            while (line != null) {
                if (line.trim().startsWith("wrapper.java.additional")) {
                    jvmOpts.add(this.windowsOptsUtil.stripQuotes(line.trim().substring(line.indexOf("=") + 1)));
                }
                line = envFileReader.readLine();
            }
            jvmOpts = this.windowsOptsUtil.removeProtectedOpts(jvmOpts);
            JvmOptions jvmOptions = this.jvmOptionsConverter.convert(jvmOpts);
            return jvmOptions;
        }
        finally {
            envFileReader.close();
        }
    }

    private String createJavaHome(Resource wrapperConf) throws IOException {
        BufferedReader envFileReader = new BufferedReader(new InputStreamReader(wrapperConf.getInputStream()));
        try {
            String line = envFileReader.readLine();
            while (line != null) {
                if (line.trim().startsWith("set.JAVA_HOME") && line.indexOf("=") != -1) {
                    String string = this.windowsOptsUtil.stripQuotes(line.substring(line.indexOf("=") + 1));
                    return string;
                }
                line = envFileReader.readLine();
            }
            return null;
        }
        finally {
            envFileReader.close();
        }
    }
}

