/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.serverdefaults;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.serverdefaults.JspDefaultsConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.serverdefaults.StaticDefaultsConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.serverdefaults.JspDefaults;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.serverdefaults.ServerDefaults;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.serverdefaults.StaticDefaults;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerDefaultsConverter
extends AbstractXmlElementConverter
implements XmlElementConverter<ServerDefaults> {
    private XmlElementConverter<JspDefaults> jspDefaultsConverter = new JspDefaultsConverter();
    private XmlElementConverter<StaticDefaults> staticDefaultsConverter = new StaticDefaultsConverter();

    @Override
    public ServerDefaults convert(Element webApp, Properties catalinaProperties) {
        ServerDefaults serverDefaults = new ServerDefaults();
        List<Element> servlets = this.getChildElements(webApp, "servlet");
        int i = 0;
        while (i < servlets.size()) {
            Element servlet = servlets.get(i);
            String servletName = this.getChildElements(servlet, "servlet-name").get(0).getTextContent();
            if ("jsp".equals(servletName)) {
                serverDefaults.setJspDefaults(this.jspDefaultsConverter.convert(servlet, catalinaProperties));
            } else if ("default".equals(servletName)) {
                serverDefaults.setStaticDefaults(this.staticDefaultsConverter.convert(servlet, catalinaProperties));
            }
            ++i;
        }
        return serverDefaults;
    }

    @Override
    public void convert(Document document, Element webApp, ServerDefaults from, Properties catalinaProperties) {
        List<Element> servlets = this.getChildElements(webApp, "servlet");
        int i = 0;
        while (i < servlets.size()) {
            Element servlet = servlets.get(i);
            String servletName = this.getChildElements(servlet, "servlet-name").get(0).getTextContent();
            if ("jsp".equals(servletName)) {
                this.jspDefaultsConverter.convert(document, servlet, from.getJspDefaults(), catalinaProperties);
            } else if ("default".equals(servletName)) {
                this.staticDefaultsConverter.convert(document, servlet, from.getStaticDefaults(), catalinaProperties);
            }
            ++i;
        }
    }
}

