/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.serverdefaults;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.serverdefaults.StaticDefaults;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticDefaultsConverter
extends AbstractXmlElementConverter
implements XmlElementConverter<StaticDefaults> {
    private static final String STATIC_DEFAULTS = "Static Defaults";
    private static final String SENDFILE_SIZE = "sendfileSize";
    private static final String README_FILE = "readmeFile";
    private static final String READONLY = "readonly";
    private static final String OUTPUT = "output";
    private static final String LISTINGS = "listings";
    private static final String INPUT = "input";
    private static final String FILE_ENCODING = "fileEncoding";
    private static final String DEBUG = "debug";

    @Override
    public void convert(Document document, Element servlet, StaticDefaults from, Properties catalinaProperties) {
        this.updateServletInitParam(document, servlet, DEBUG, from.getDebug(), catalinaProperties);
        this.updateServletInitParam(document, servlet, FILE_ENCODING, from.getFileEncoding(), catalinaProperties);
        this.updateServletInitParam(document, servlet, INPUT, from.getInput(), catalinaProperties);
        this.updateServletInitParam(document, servlet, LISTINGS, from.getListings(), catalinaProperties);
        this.updateServletInitParam(document, servlet, OUTPUT, from.getOutput(), catalinaProperties);
        this.updateServletInitParam(document, servlet, README_FILE, from.getReadmeFile(), catalinaProperties);
        this.updateServletInitParam(document, servlet, READONLY, from.getReadonly(), catalinaProperties);
        this.updateServletInitParam(document, servlet, SENDFILE_SIZE, from.getSendfileSize(), catalinaProperties);
    }

    @Override
    public StaticDefaults convert(Element servlet, Properties catalinaProperties) {
        StaticDefaults staticDefaults = new StaticDefaults();
        List<Element> initParams = this.getChildElements(servlet, "init-param");
        for (Element initParam : initParams) {
            String paramName = this.getChildElements(initParam, "param-name").get(0).getTextContent();
            this.updateParameter(staticDefaults, paramName, initParam, catalinaProperties);
        }
        return staticDefaults;
    }

    private void updateParameter(StaticDefaults staticDefaults, String paramName, Element initParam, Properties catalinaProperties) {
        String paramValue = this.parseProperties(this.getChildElements(initParam, "param-value").get(0).getTextContent(), catalinaProperties);
        if (!"".equals(paramValue)) {
            if (DEBUG.equals(paramName)) {
                try {
                    staticDefaults.setDebug(Long.valueOf(paramValue));
                }
                catch (NumberFormatException numberFormatException) {
                    this.logNonNumericValue(STATIC_DEFAULTS, DEBUG, paramValue);
                }
            } else if (FILE_ENCODING.equals(paramName)) {
                staticDefaults.setFileEncoding(paramValue);
            } else if (INPUT.equals(paramName)) {
                try {
                    staticDefaults.setInput(Long.valueOf(paramValue));
                }
                catch (NumberFormatException numberFormatException) {
                    this.logNonNumericValue(STATIC_DEFAULTS, INPUT, paramValue);
                }
            } else if (LISTINGS.equals(paramName)) {
                staticDefaults.setListings(Boolean.valueOf(paramValue));
            } else if (OUTPUT.equals(paramName)) {
                try {
                    staticDefaults.setOutput(Long.valueOf(paramValue));
                }
                catch (NumberFormatException numberFormatException) {
                    this.logNonNumericValue(STATIC_DEFAULTS, OUTPUT, paramValue);
                }
            } else if (READONLY.equals(paramName)) {
                staticDefaults.setReadonly(Boolean.valueOf(paramValue));
            } else if (README_FILE.equals(paramName)) {
                staticDefaults.setReadmeFile(paramValue);
            } else if (SENDFILE_SIZE.equals(paramName)) {
                try {
                    staticDefaults.setSendfileSize(Long.valueOf(paramValue));
                }
                catch (NumberFormatException numberFormatException) {
                    this.logNonNumericValue(STATIC_DEFAULTS, SENDFILE_SIZE, paramValue);
                }
            }
        }
    }
}

