/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.services;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.ServiceConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.services.Service;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesConverter
extends AbstractXmlElementConverter
implements XmlElementConverter<Set<Service>> {
    private XmlElementConverter<Service> serviceConverter = new ServiceConverter();

    @Override
    public void convert(Document document, Element server, Set<Service> from, Properties catalinaProperties) {
        List<Element> serviceNodes = this.getChildElements(server, "Service");
        HashSet<String> serviceIds = new HashSet<String>(from.size());
        for (Service service : from) {
            serviceIds.add(service.getId());
        }
        HashMap<String, Element> serviceElements = new HashMap<String, Element>();
        int i = 0;
        while (i < serviceNodes.size()) {
            String elementName = this.parseProperties(serviceNodes.get(i).getAttribute("name"), catalinaProperties);
            if (serviceIds.contains(elementName)) {
                serviceElements.put(elementName, serviceNodes.get(i));
            } else {
                server.removeChild(serviceNodes.get(i));
            }
            ++i;
        }
        for (Service service : from) {
            if (serviceElements.get(service.getId()) == null) {
                Element serviceElement = document.createElement("Service");
                this.serviceConverter.convert(document, serviceElement, service, catalinaProperties);
                server.appendChild(serviceElement);
                continue;
            }
            this.serviceConverter.convert(document, (Element)serviceElements.get(service.getId()), service, catalinaProperties);
        }
    }

    @Override
    public Set<Service> convert(Element server, Properties catalinaProperties) {
        HashSet<Service> services = new HashSet<Service>();
        List<Element> serviceNodes = this.getChildElements(server, "Service");
        int i = 0;
        while (i < serviceNodes.size()) {
            Service service = this.serviceConverter.convert(serviceNodes.get(i), catalinaProperties);
            services.add(service);
            ++i;
        }
        return services;
    }
}

