/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.connector;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.connector.ConnectorConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.services.connector.Connector;
import com.springsource.hq.plugin.tcserver.serverconfig.services.connector.HttpConnector;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpConnectorConverter
extends ConnectorConverter
implements XmlElementConverter<HttpConnector> {
    private static final String HTTP_CONNECTOR = "Http Connector";
    private static final String SSL_ENABLED = "SSLEnabled";
    private static final String SECURE = "secure";
    private static final String PROTOCOL = "protocol";
    private static final String MAX_KEEP_ALIVE_REQUESTS = "maxKeepAliveRequests";
    private static final String KEYSTORE_PASS = "keystorePass";
    private static final String KEYSTORE_FILE = "keystoreFile";
    private static final String KEY_ALIAS = "keyAlias";
    private static final String ALGORITHM = "algorithm";
    private static final String ACCEPT_COUNT = "acceptCount";

    @Override
    public HttpConnector convert(Element connectorElement, Properties catalinaProperties) {
        String SSLEnabled;
        String secure;
        String maxKeepAliveRequests;
        String keystorePass;
        String keystoreFile;
        String keyAlias;
        String algorithm;
        HttpConnector connector = new HttpConnector();
        this.convert((Connector)connector, connectorElement, catalinaProperties);
        String protocol = this.parseProperties(connectorElement.getAttribute(PROTOCOL), catalinaProperties);
        connector.setProtocol(protocol);
        String acceptCount = this.parseProperties(connectorElement.getAttribute(ACCEPT_COUNT), catalinaProperties);
        if (!"".equals(acceptCount)) {
            try {
                connector.setAcceptCount(Long.valueOf(acceptCount));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(HTTP_CONNECTOR, ACCEPT_COUNT, acceptCount);
            }
        }
        if (!"".equals(algorithm = this.parseProperties(connectorElement.getAttribute(ALGORITHM), catalinaProperties))) {
            connector.setAlgorithm(algorithm);
        }
        if (!"".equals(keyAlias = this.parseProperties(connectorElement.getAttribute(KEY_ALIAS), catalinaProperties))) {
            connector.setKeyAlias(keyAlias);
        }
        if (!"".equals(keystoreFile = this.parseProperties(connectorElement.getAttribute(KEYSTORE_FILE), catalinaProperties))) {
            connector.setKeystoreFile(keystoreFile);
        }
        if (!"".equals(keystorePass = this.parseProperties(connectorElement.getAttribute(KEYSTORE_PASS), catalinaProperties))) {
            connector.setKeystorePass(keystorePass);
        }
        if (!"".equals(maxKeepAliveRequests = this.parseProperties(connectorElement.getAttribute(MAX_KEEP_ALIVE_REQUESTS), catalinaProperties))) {
            try {
                connector.setMaxKeepAliveRequests(Long.valueOf(maxKeepAliveRequests));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(HTTP_CONNECTOR, MAX_KEEP_ALIVE_REQUESTS, maxKeepAliveRequests);
            }
        }
        if (!"".equals(secure = this.parseProperties(connectorElement.getAttribute(SECURE), catalinaProperties))) {
            connector.setSecure(Boolean.valueOf(secure));
        }
        if (!"".equals(SSLEnabled = this.parseProperties(connectorElement.getAttribute(SSL_ENABLED), catalinaProperties))) {
            connector.setSSLEnabled(Boolean.valueOf(SSLEnabled));
        }
        return connector;
    }

    @Override
    public void convert(Document document, Element connectorElement, HttpConnector from, Properties catalinaProperties) {
        super.convert(document, connectorElement, (Connector)from, catalinaProperties);
        this.setAttribute(connectorElement, PROTOCOL, from.getProtocol(), catalinaProperties, true);
        this.setAttribute(connectorElement, ACCEPT_COUNT, from.getAcceptCount(), catalinaProperties, false);
        this.setAttribute(connectorElement, ALGORITHM, from.getAlgorithm(), catalinaProperties, false);
        this.setAttribute(connectorElement, KEY_ALIAS, from.getKeyAlias(), catalinaProperties, false);
        this.setAttribute(connectorElement, KEYSTORE_FILE, from.getKeystoreFile(), catalinaProperties, false);
        this.setAttribute(connectorElement, KEYSTORE_PASS, from.getKeystorePass(), catalinaProperties, false);
        this.setAttribute(connectorElement, MAX_KEEP_ALIVE_REQUESTS, from.getMaxKeepAliveRequests(), catalinaProperties, false);
        this.setAttribute(connectorElement, SECURE, from.getSecure(), catalinaProperties, false);
        this.setAttribute(connectorElement, SSL_ENABLED, from.getSSLEnabled(), catalinaProperties, false);
    }
}

