/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.engine;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AttributeNotFoundException;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.engine.AccessLogValveConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.engine.HostConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.engine.ThreadDiagnosticsValveConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.services.engine.Engine;
import com.springsource.hq.plugin.tcserver.serverconfig.services.engine.Host;
import com.springsource.hq.plugin.tcserver.serverconfig.services.engine.Logging;
import com.springsource.hq.plugin.tcserver.serverconfig.services.engine.ThreadDiagnostics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineConverter
extends AbstractXmlElementConverter
implements XmlElementConverter<Engine> {
    private static final String JVM_ROUTE = "jvmRoute";
    private static final String NAME = "name";
    private static final String DEFAULT_HOST = "defaultHost";
    private XmlElementConverter<Logging<Engine>> engineAccessLogValveConverter = new AccessLogValveConverter<Engine>();
    private XmlElementConverter<ThreadDiagnostics> engineThreadDiagnosticsValveConverter = new ThreadDiagnosticsValveConverter();
    private XmlElementConverter<Host> hostConverter = new HostConverter();

    @Override
    public Engine convert(Element engineNode, Properties catalinaProperties) {
        Engine engine = new Engine();
        String defaultHost = this.parseProperties(engineNode.getAttribute(DEFAULT_HOST), catalinaProperties);
        if ("".equals(defaultHost)) {
            throw new AttributeNotFoundException(DEFAULT_HOST, "Engine");
        }
        engine.setDefaultHost(defaultHost);
        String name = this.parseProperties(engineNode.getAttribute(NAME), catalinaProperties);
        if ("".equals(name)) {
            throw new AttributeNotFoundException(NAME, "Engine");
        }
        engine.setName(name);
        String jvmRoute = this.parseProperties(engineNode.getAttribute(JVM_ROUTE), catalinaProperties);
        if (!"".equals(jvmRoute)) {
            engine.setJvmRoute(jvmRoute);
        }
        engine.setHosts(this.createHosts(engineNode, catalinaProperties));
        engine.setLogging(this.createEngineLogging(engineNode, catalinaProperties));
        engine.setThreadDiagnostics(this.createEngineThreadDiagnostics(engineNode, catalinaProperties));
        return engine;
    }

    @Override
    public void convert(Document document, Element engine, Engine from, Properties catalinaProperties) {
        this.setAttribute(engine, DEFAULT_HOST, from.getDefaultHost(), catalinaProperties, true);
        this.setAttribute(engine, NAME, from.getName(), catalinaProperties, true);
        this.setAttribute(engine, JVM_ROUTE, from.getJvmRoute(), catalinaProperties, false);
        this.convertHosts(document, engine, from.getHosts(), catalinaProperties);
        this.convertLogging(document, engine, (Logging<Engine>)from.getLogging(), catalinaProperties);
        this.convertThreadDiagnostics(document, engine, from.getThreadDiagnostics(), catalinaProperties);
    }

    private void convertHosts(Document document, Element engineNode, Set<Host> hosts, Properties catalinaProperties) {
        List<Element> hostNodes = this.getChildElements(engineNode, "Host");
        HashSet<String> hostIds = new HashSet<String>(hosts.size());
        for (Host host : hosts) {
            hostIds.add(host.getId());
        }
        HashMap<String, Element> hostElements = new HashMap<String, Element>();
        int i = 0;
        while (i < hostNodes.size()) {
            String elementName = this.parseProperties(hostNodes.get(i).getAttribute(NAME), catalinaProperties);
            if (hostIds.contains(elementName)) {
                hostElements.put(elementName, hostNodes.get(i));
            } else {
                engineNode.removeChild(hostNodes.get(i));
            }
            ++i;
        }
        for (Host host : hosts) {
            if (hostElements.get(host.getId()) == null) {
                Element hostElement = document.createElement("Host");
                this.hostConverter.convert(document, hostElement, host, catalinaProperties);
                engineNode.appendChild(hostElement);
                continue;
            }
            this.hostConverter.convert(document, (Element)hostElements.get(host.getId()), host, catalinaProperties);
        }
    }

    private void convertLogging(Document document, Element engineNode, Logging<Engine> logging, Properties catalinaProperties) {
        Element accessLogValve = null;
        List<Element> valveNodes = this.getChildElements(engineNode, "Valve");
        int i = 0;
        while (i < valveNodes.size()) {
            Element valve = valveNodes.get(i);
            if ("org.apache.catalina.valves.AccessLogValve".equals(valve.getAttribute("className"))) {
                if (!logging.getEnabled().booleanValue()) {
                    engineNode.removeChild(valve);
                    return;
                }
                accessLogValve = valve;
                break;
            }
            ++i;
        }
        if (logging.getEnabled().booleanValue()) {
            if (accessLogValve == null) {
                accessLogValve = document.createElement("Valve");
                accessLogValve.setAttribute("className", "org.apache.catalina.valves.AccessLogValve");
                engineNode.appendChild(accessLogValve);
            }
            this.engineAccessLogValveConverter.convert(document, accessLogValve, logging, catalinaProperties);
        }
    }

    private Logging<Engine> createEngineLogging(Element engineNode, Properties catalinaProperties) {
        List<Element> valveNodes = this.getChildElements(engineNode, "Valve");
        int i = 0;
        while (i < valveNodes.size()) {
            Element valve = valveNodes.get(i);
            if ("org.apache.catalina.valves.AccessLogValve".equals(valve.getAttribute("className"))) {
                return this.engineAccessLogValveConverter.convert(valve, catalinaProperties);
            }
            ++i;
        }
        return new Logging();
    }

    private void convertThreadDiagnostics(Document document, Element engineNode, ThreadDiagnostics threadDiagnositcs, Properties catalinaProperties) {
        Element threadDiagnositcsValve = null;
        List<Element> valveNodes = this.getChildElements(engineNode, "Valve");
        int i = 0;
        while (i < valveNodes.size()) {
            Element valve = valveNodes.get(i);
            if ("com.springsource.tcserver.serviceability.request.ThreadDiagnosticsValve".equals(valve.getAttribute("className"))) {
                if (!threadDiagnositcs.getEnabled().booleanValue()) {
                    engineNode.removeChild(valve);
                    return;
                }
                threadDiagnositcsValve = valve;
                break;
            }
            ++i;
        }
        if (threadDiagnositcs.getEnabled().booleanValue()) {
            if (threadDiagnositcsValve == null) {
                threadDiagnositcsValve = document.createElement("Valve");
                threadDiagnositcsValve.setAttribute("className", "com.springsource.tcserver.serviceability.request.ThreadDiagnosticsValve");
                engineNode.appendChild(threadDiagnositcsValve);
            }
            this.engineThreadDiagnosticsValveConverter.convert(document, threadDiagnositcsValve, threadDiagnositcs, catalinaProperties);
        }
    }

    private ThreadDiagnostics createEngineThreadDiagnostics(Element engineNode, Properties catalinaProperties) {
        List<Element> valveNodes = this.getChildElements(engineNode, "Valve");
        int i = 0;
        while (i < valveNodes.size()) {
            Element valve = valveNodes.get(i);
            if ("com.springsource.tcserver.serviceability.request.ThreadDiagnosticsValve".equals(valve.getAttribute("className"))) {
                return this.engineThreadDiagnosticsValveConverter.convert(valve, catalinaProperties);
            }
            ++i;
        }
        return new ThreadDiagnostics();
    }

    private Set<Host> createHosts(Element engine, Properties catalinaProperties) {
        HashSet<Host> hosts = new HashSet<Host>();
        List<Element> hostNodes = this.getChildElements(engine, "Host");
        int i = 0;
        while (i < hostNodes.size()) {
            Host host = this.hostConverter.convert(hostNodes.get(i), catalinaProperties);
            hosts.add(host);
            ++i;
        }
        return hosts;
    }
}

