/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.engine;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AttributeNotFoundException;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.engine.AccessLogValveConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.services.engine.Host;
import com.springsource.hq.plugin.tcserver.serverconfig.services.engine.Logging;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostConverter
extends AbstractXmlElementConverter
implements XmlElementConverter<Host> {
    private static final String WORK_DIR = "workDir";
    private static final String UNPACK_WARS = "unpackWARs";
    private static final String NAME = "name";
    private static final String DEPLOY_XML = "deployXML";
    private static final String DEPLOY_ON_STARTUP = "deployOnStartup";
    private static final String AUTO_DEPLOY = "autoDeploy";
    private static final String APP_BASE = "appBase";
    private AccessLogValveConverter<Host> hostAccessLogValveConverter = new AccessLogValveConverter();

    @Override
    public Host convert(Element hostNode, Properties catalinaProperties) {
        String workDir;
        String deployXML;
        String deployOnStartup;
        String autoDeploy;
        Host host = new Host();
        String appBase = this.parseProperties(hostNode.getAttribute(APP_BASE), catalinaProperties);
        if (!"".equals(appBase)) {
            host.setAppBase(appBase);
        }
        if (!"".equals(autoDeploy = this.parseProperties(hostNode.getAttribute(AUTO_DEPLOY), catalinaProperties))) {
            host.setAutoDeploy(Boolean.valueOf(autoDeploy));
        }
        if (!"".equals(deployOnStartup = this.parseProperties(hostNode.getAttribute(DEPLOY_ON_STARTUP), catalinaProperties))) {
            host.setDeployOnStartup(Boolean.valueOf(deployOnStartup));
        }
        if (!"".equals(deployXML = this.parseProperties(hostNode.getAttribute(DEPLOY_XML), catalinaProperties))) {
            host.setDeployXML(Boolean.valueOf(deployXML));
        }
        host.setLogging(this.createHostLogging(hostNode, catalinaProperties));
        String name = this.parseProperties(hostNode.getAttribute(NAME), catalinaProperties);
        if ("".equals(name)) {
            throw new AttributeNotFoundException(NAME, "Host");
        }
        host.setName(name);
        host.setId(name);
        String unpackWARs = this.parseProperties(hostNode.getAttribute(UNPACK_WARS), catalinaProperties);
        if (!"".equals(unpackWARs)) {
            host.setUnpackWARs(Boolean.valueOf(unpackWARs));
        }
        if (!"".equals(workDir = this.parseProperties(hostNode.getAttribute(WORK_DIR), catalinaProperties))) {
            host.setWorkDir(workDir);
        }
        return host;
    }

    @Override
    public void convert(Document document, Element hostNode, Host from, Properties catalinaProperties) {
        this.setAttribute(hostNode, APP_BASE, from.getAppBase(), catalinaProperties, false);
        this.setAttribute(hostNode, AUTO_DEPLOY, from.getAutoDeploy(), catalinaProperties, false);
        this.setAttribute(hostNode, DEPLOY_ON_STARTUP, from.getDeployOnStartup(), catalinaProperties, false);
        this.setAttribute(hostNode, DEPLOY_XML, from.getDeployXML(), catalinaProperties, false);
        this.setAttribute(hostNode, NAME, from.getName(), catalinaProperties, true);
        this.setAttribute(hostNode, UNPACK_WARS, from.getUnpackWARs(), catalinaProperties, false);
        this.setAttribute(hostNode, WORK_DIR, from.getWorkDir(), catalinaProperties, false);
        this.convertLogging(document, hostNode, (Logging<Host>)from.getLogging(), catalinaProperties);
    }

    private void convertLogging(Document document, Element hostNode, Logging<Host> logging, Properties catalinaProperties) {
        Element accessLogValve = null;
        List<Element> valveNodes = this.getChildElements(hostNode, "Valve");
        int i = 0;
        while (i < valveNodes.size()) {
            Element valve = valveNodes.get(i);
            if ("org.apache.catalina.valves.AccessLogValve".equals(valve.getAttribute("className"))) {
                if (!logging.getEnabled().booleanValue()) {
                    hostNode.removeChild(valve);
                    return;
                }
                accessLogValve = valve;
                break;
            }
            ++i;
        }
        if (logging.getEnabled().booleanValue()) {
            if (accessLogValve == null) {
                accessLogValve = document.createElement("Valve");
                accessLogValve.setAttribute("className", "org.apache.catalina.valves.AccessLogValve");
                hostNode.appendChild(accessLogValve);
            }
            this.hostAccessLogValveConverter.convert(document, accessLogValve, logging, catalinaProperties);
        }
    }

    private Logging<Host> createHostLogging(Element hostNode, Properties catalinaProperties) {
        List<Element> valveNodes = this.getChildElements(hostNode, "Valve");
        int i = 0;
        while (i < valveNodes.size()) {
            Element valve = valveNodes.get(i);
            if ("org.apache.catalina.valves.AccessLogValve".equals(valve.getAttribute("className"))) {
                return this.hostAccessLogValveConverter.convert(valve, catalinaProperties);
            }
            ++i;
        }
        return new Logging();
    }
}

