/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.wrapper;

import com.springsource.hq.plugin.tcserver.plugin.wrapper.JmxUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.config.ConfigResponse;

public final class MxUtilJmxUtils
implements JmxUtils {
    private final Log log = LogFactory.getLog(MxUtilJmxUtils.class);

    public MBeanServerConnection getMBeanServer(Properties configProperties) throws MalformedURLException, IOException {
        return MxUtil.getMBeanServer((Properties)configProperties);
    }

    public Object getValue(Properties configProperties, String appObjectName, String string) throws MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MalformedURLException, MBeanException, ReflectionException, PluginException, IOException {
        return MxUtil.getValue((Properties)configProperties, (String)appObjectName, (String)string);
    }

    public Object invoke(Properties configProperties, String objectName, String string, Object[] objects, String[] strings) throws MetricUnreachableException, MetricNotFoundException, PluginException {
        return MxUtil.invoke((Properties)configProperties, (String)objectName, (String)string, (Object[])objects, (String[])strings);
    }

    public String getJmxUrlProperty() {
        return "jmx.url";
    }

    public boolean checkConnection(ConfigResponse config) {
        JMXConnector jmxConnector = null;
        try {
            jmxConnector = MxUtil.getMBeanConnector((Properties)config.toProperties());
            return true;
        }
        catch (IOException ioe) {
            this.log.warn((Object)"Connection check failed", (Throwable)ioe);
            return false;
        }
        finally {
            if (jmxConnector != null) {
                try {
                    jmxConnector.close();
                }
                catch (IOException ioe) {
                    this.log.warn((Object)"Failed to close connection following check", (Throwable)ioe);
                }
            }
        }
    }
}

